/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_forge.networking.packets;

import com.google.common.collect.Maps;
import com.natamus.collective_common_forge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_forge.implementations.networking.data.Side;
import com.natamus.starterkit_common_forge.data.VariablesClient;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ToClientReceiveKitDataPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("starterkit", "to_client_receive_kit_data_packet");
    private final HashMap<String, String> packetStarterGearEntries;
    private final HashMap<String, String> packetStarterKitDescriptions;

    public ToClientReceiveKitDataPacket(HashMap<String, String> entriesIn, HashMap<String, String> descriptionsIn) {
        this.packetStarterGearEntries = entriesIn;
        this.packetStarterKitDescriptions = descriptionsIn;
    }

    public static ToClientReceiveKitDataPacket decode(FriendlyByteBuf buf) {
        HashMap entriesIn = (HashMap)buf.m_236841_(Maps::newHashMapWithExpectedSize, FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_);
        HashMap descriptionsIn = (HashMap)buf.m_236841_(Maps::newHashMapWithExpectedSize, FriendlyByteBuf::m_130277_, FriendlyByteBuf::m_130277_);
        return new ToClientReceiveKitDataPacket(entriesIn, descriptionsIn);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236831_(this.packetStarterGearEntries, (a, b) -> a.m_130070_(b), (a, b) -> a.m_130070_(b));
        buf.m_236831_(this.packetStarterKitDescriptions, (a, b) -> a.m_130070_(b), (a, b) -> a.m_130070_(b));
    }

    public static void handle(PacketContext<ToClientReceiveKitDataPacket> ctx) {
        if (ctx.side().equals((Object)Side.CLIENT)) {
            ToClientReceiveKitDataPacket packet = (ToClientReceiveKitDataPacket)ctx.message();
            VariablesClient.cachedStarterGearEntries = packet.packetStarterGearEntries;
            VariablesClient.cachedStarterKitDescriptions = packet.packetStarterKitDescriptions;
            VariablesClient.openChooseKitScreen = true;
        }
    }
}

