/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BlastFurnaceLogic;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.NonMirrorableWithActiveBlock;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.AdvBlastFurnaceShapes;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

public class AdvBlastFurnaceLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final Vec3 SMOKE_POS = new Vec3(1.5, 3.9, 1.5);
    private static final BlockPos[] HEATER_OFFSETS = new BlockPos[]{new BlockPos(-1, 0, 1), new BlockPos(3, 0, 1)};
    private static final MultiblockFace OUTPUT_OFFSET = new MultiblockFace(1, 0, -1, RelativeBlockFace.FRONT);
    private static final MultiblockFace SLAG_OUTPUT_OFFSET = new MultiblockFace(1, 0, 3, RelativeBlockFace.BACK);
    private static final CapabilityPosition OUTPUT_CAP = CapabilityPosition.opposing(OUTPUT_OFFSET);
    private static final CapabilityPosition SLAG_OUTPUT_CAP = CapabilityPosition.opposing(SLAG_OUTPUT_OFFSET);
    private static final CapabilityPosition INPUT_CAP = new CapabilityPosition(1, 3, 1, RelativeBlockFace.UP);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        IMultiblockLevel level = context.getLevel();
        boolean wasActive = this.isActive(level);
        boolean active = context.getState().innerState.furnace.tickServer(context);
        if (active != wasActive) {
            NonMirrorableWithActiveBlock.setActive(level, IEMultiblocks.ADVANCED_BLAST_FURNACE, active);
        }
        if (!level.shouldTickModulo(8)) {
            return;
        }
        State state = context.getState();
        IItemHandlerModifiable inventory = state.innerState.getInventory();
        ItemStack stack = inventory.getStackInSlot(2);
        if (!stack.m_41619_()) {
            stack = Utils.insertStackIntoInventory(state.outputRef, stack, false);
            inventory.setStackInSlot(2, stack);
        }
        if (!(stack = inventory.getStackInSlot(3)).m_41619_()) {
            stack = Utils.insertStackIntoInventory(state.slagRef, stack, false);
            inventory.setStackInSlot(3, stack);
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        IMultiblockLevel level = context.getLevel();
        if (this.isActive(level)) {
            Vec3 particlePos = level.toAbsolute(SMOKE_POS);
            level.getRawLevel().m_7107_((ParticleOptions)ParticleTypes.f_123777_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, ApiUtils.RANDOM.nextDouble(-0.00625, 0.00625), 0.05, ApiUtils.RANDOM.nextDouble(-0.00625, 0.00625));
        }
    }

    private boolean isActive(IMultiblockLevel level) {
        return (Boolean)level.getBlockState(IEMultiblocks.ADVANCED_BLAST_FURNACE.getMasterFromOriginOffset()).m_61143_(NonMirrorableWithActiveBlock.ACTIVE);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            State state = ctx.getState();
            if (OUTPUT_CAP.equals(position)) {
                return state.outputHandler.cast(ctx);
            }
            if (SLAG_OUTPUT_CAP.equals(position)) {
                return state.slagHandler.cast(ctx);
            }
            if (INPUT_CAP.equals(position)) {
                return state.inputHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.getInventory(), drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return AdvBlastFurnaceShapes.SHAPE_GETTER;
    }

    public static class State
    implements IMultiblockState,
    FurnaceHandler.IFurnaceEnvironment<BlastFurnaceRecipe> {
        private final BlastFurnaceLogic.State innerState;
        private final CapabilityReference<IItemHandler> outputRef;
        private final CapabilityReference<IItemHandler> slagRef;
        private final StoredCapability<IItemHandler> inputHandler;
        private final StoredCapability<IItemHandler> outputHandler;
        private final StoredCapability<IItemHandler> slagHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            this.innerState = new BlastFurnaceLogic.State(ctx);
            this.outputRef = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, OUTPUT_OFFSET);
            this.slagRef = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, SLAG_OUTPUT_OFFSET);
            this.inputHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.getInventory(), true, false, new WrappingItemHandler.IntRange(0, 2)));
            this.outputHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.getInventory(), false, true, new WrappingItemHandler.IntRange(2, 3)));
            this.slagHandler = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.getInventory(), false, true, new WrappingItemHandler.IntRange(3, 4)));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            this.innerState.writeSaveNBT(nbt);
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.innerState.readSaveNBT(nbt);
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.innerState.getInventory();
        }

        @Override
        @Nullable
        public BlastFurnaceRecipe getRecipeForInput() {
            return this.innerState.getRecipeForInput();
        }

        @Override
        public int getBurnTimeOf(Level level, ItemStack fuel) {
            return this.innerState.getBurnTimeOf(level, fuel);
        }

        @Override
        public int getProcessSpeed(IMultiblockLevel level) {
            int i = 1;
            for (BlockPos offset : HEATER_OFFSETS) {
                BlastFurnacePreheaterBlockEntity preheater = this.getPreheater(level, offset);
                if (preheater == null) continue;
                i += preheater.doSpeedup();
            }
            return i;
        }

        @Override
        public void turnOff(IMultiblockLevel level) {
            for (BlockPos offset : HEATER_OFFSETS) {
                BlastFurnacePreheaterBlockEntity preheater = this.getPreheater(level, offset);
                if (preheater == null) continue;
                preheater.turnOff();
            }
        }

        @Nullable
        public BlastFurnacePreheaterBlockEntity getPreheater(IMultiblockLevel level, BlockPos pos) {
            BlastFurnacePreheaterBlockEntity heater;
            BlockEntity te = level.getBlockEntity(pos);
            return te instanceof BlastFurnacePreheaterBlockEntity ? (heater = (BlastFurnacePreheaterBlockEntity)te) : null;
        }

        public GetterAndSetter<Boolean> preheaterActive(IMultiblockLevel level, int index) {
            return GetterAndSetter.getterOnly(() -> {
                BlastFurnacePreheaterBlockEntity heater = this.getPreheater(level, HEATER_OFFSETS[index]);
                return heater != null && heater.active;
            });
        }

        public ContainerData getStateView() {
            return this.innerState.getStateView();
        }
    }
}

