/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class PowerpackRecipe
implements CraftingRecipe {
    private final ResourceLocation id;

    public PowerpackRecipe(ResourceLocation id) {
        this.id = id;
    }

    public boolean m_5598_() {
        return true;
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        ItemStack powerpack = ItemStack.f_41583_;
        ItemStack armor = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (powerpack.m_41619_() && stackInSlot.m_150930_(IEItems.Misc.POWERPACK.m_5456_())) {
                powerpack = stackInSlot;
                continue;
            }
            if (armor.m_41619_() && this.isValidArmor(stackInSlot)) {
                armor = stackInSlot;
                continue;
            }
            return false;
        }
        if (!(powerpack.m_41619_() || armor.m_41619_() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            return true;
        }
        return !armor.m_41619_() && ItemNBTHelper.hasKey(armor, "IE:Powerpack") && powerpack.m_41619_();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack powerpack = ItemStack.f_41583_;
        ItemStack armor = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (powerpack.m_41619_() && stackInSlot.m_150930_(IEItems.Misc.POWERPACK.m_5456_())) {
                powerpack = stackInSlot;
                continue;
            }
            if (!armor.m_41619_() || !this.isValidArmor(stackInSlot)) continue;
            armor = stackInSlot;
        }
        if (!(powerpack.m_41619_() || armor.m_41619_() || ItemNBTHelper.hasKey(armor, "IE:Powerpack"))) {
            ItemStack output = armor.m_41777_();
            ItemNBTHelper.setItemStack(output, "IE:Powerpack", ItemHandlerHelper.copyStackWithSize((ItemStack)powerpack, (int)1));
            return output;
        }
        if (!armor.m_41619_() && ItemNBTHelper.hasKey(armor, "IE:Powerpack")) {
            ItemStack output = armor.m_41777_();
            ItemNBTHelper.remove(output, "IE:Powerpack");
            return output;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    @Nonnull
    public ItemStack m_8043_(RegistryAccess access) {
        return new ItemStack(IEItems.Misc.POWERPACK, 1);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remaining = super.m_7457_((Container)inv);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_() || !ItemNBTHelper.hasKey(stackInSlot, "IE:Powerpack")) continue;
            remaining.set(i, (Object)ItemNBTHelper.getItemStack(stackInSlot, "IE:Powerpack"));
        }
        return remaining;
    }

    private boolean isValidArmor(ItemStack stack) {
        ArmorItem armor;
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40402_() != EquipmentSlot.CHEST) {
            return false;
        }
        if (stack.m_41720_() == IEItems.Misc.POWERPACK.m_5456_()) {
            return false;
        }
        return !stack.m_204117_(IETags.powerpackForbidAttach);
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.POWERPACK_SERIALIZER.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122780_((int)1, (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{IEItems.Misc.POWERPACK}));
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }
}

