/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.menu;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.init.ModMenuTypes;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.AbstractBackpackMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.DisabledSlot;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BackpackSettingsMenu
extends AbstractBackpackMenu {
    private ContainerLevelAccess access;
    private Block backpackBlock;

    public BackpackSettingsMenu(int windowID, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowID, playerInventory, BackpackSettingsMenu.createWrapper(playerInventory, data));
    }

    public BackpackSettingsMenu(int windowID, Inventory playerInventory, BackpackWrapper wrapper) {
        this((MenuType)ModMenuTypes.BACKPACK_SETTINGS_MENU.get(), windowID, playerInventory, wrapper);
        if (this.wrapper.getScreenID() == 3) {
            this.access = ContainerLevelAccess.m_39289_((Level)this.player.m_9236_(), (BlockPos)this.getWrapper().getBackpackPos());
            this.backpackBlock = this.player.m_9236_().m_8055_(this.getWrapper().getBackpackPos()).m_60734_();
            this.wrapper.addUser(this.inventory.f_35978_);
        } else {
            this.wrapper.addUser(playerInventory.f_35978_);
        }
    }

    public BackpackSettingsMenu(MenuType<?> type, int windowID, Inventory inventory, BackpackWrapper wrapper) {
        super(type, windowID, inventory, wrapper);
        this.addSlots();
    }

    public void updateSlots() {
        this.f_38841_.clear();
        this.f_38839_.clear();
        this.f_150394_.clear();
        this.addSlots();
    }

    public void addSlots() {
        this.addBackpackStorageSlots(this.wrapper);
        this.BACKPACK_INV_END = this.f_38839_.size();
        this.PLAYER_INV_START = this.f_38839_.size();
        this.addPlayerInventoryAndHotbar(this.inventory, this.getWrapper().getBackpackSlotIndex());
        this.PLAYER_HOT_END = this.f_38839_.size();
    }

    public void addPlayerInventoryAndHotbar(Inventory inventory, int currentItemIndex) {
        int modifiedOffset = this.extendedScreenOffset;
        if (this.wrapper.isExtended()) {
            modifiedOffset += 18;
        }
        if (this.wrapper.getScreenID() == 1) {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    if (x + y * 9 + 9 == currentItemIndex) {
                        this.m_38897_(new DisabledSlot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                        this.disabledSlotIndex = this.f_38839_.size() - 1;
                        continue;
                    }
                    this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 7 + 25 + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                if (x == currentItemIndex) {
                    this.m_38897_(new DisabledSlot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
                    this.disabledSlotIndex = this.f_38839_.size() - 1;
                    continue;
                }
                this.m_38897_(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
            }
        } else {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, modifiedOffset + 8 + x * 18, 18 + this.wrapper.getRows() * 18 + 14 + y * 18));
                }
            }
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x, modifiedOffset + 8 + x * 18, this.wrapper.getRows() * 18 + 10 + 80));
            }
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return false;
    }

    public ItemStack m_7648_(Player player, int index) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(Player player) {
        BlockEntity blockEntity;
        BlockPos pos;
        if (!player.m_9236_().f_46443_ && this.getWrapper().getScreenID() == 3 && (pos = this.getWrapper().getBackpackPos()) != null && (blockEntity = player.m_9236_().m_7702_(pos)) instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntity;
            backpackBlockEntity.removeSettingsUser();
        }
        if (player.f_36096_ instanceof BackpackSettingsMenu && player.m_9236_().f_46443_) {
            return;
        }
        if (player.f_36096_ instanceof BackpackSettingsMenu) {
            this.wrapper.playersUsing.remove(player);
        }
        super.m_6877_(player);
    }

    public boolean m_6875_(Player player) {
        if (this.getWrapper().getScreenID() == 3) {
            return (Boolean)this.access.m_39299_((level, blockPos) -> !level.m_8055_(blockPos).m_60713_(this.backpackBlock) ? false : player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
        }
        if (this.getWrapper().getBackpackOwner() != null) {
            return this.getWrapper().getBackpackOwner().m_6084_() && CapabilityUtils.isWearingBackpack(this.getWrapper().getBackpackOwner());
        }
        return true;
    }

    private static BackpackWrapper createWrapper(Inventory inventory, FriendlyByteBuf data) {
        Objects.requireNonNull(inventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        boolean isBlockEntity = data.readBoolean();
        if (isBlockEntity) {
            return BackpackSettingsMenu.getBlockEntity(inventory, data);
        }
        return BackpackSettingsMenu.getWrapper(inventory, data);
    }

    private static BackpackWrapper getWrapper(Inventory inventory, FriendlyByteBuf data) {
        ItemStack backpackStack;
        int screenID = data.readInt();
        BlockPos pos = data.m_130135_();
        int index = data.readInt();
        ItemStack itemStack = backpackStack = index == -1 ? inventory.f_35978_.m_21120_(InteractionHand.MAIN_HAND) : (ItemStack)inventory.f_35974_.get(index);
        if (screenID == 2) {
            return CapabilityUtils.getBackpackWrapper(inventory.f_35978_);
        }
        return new BackpackWrapper(backpackStack, screenID, inventory.f_35978_, inventory.f_35978_.m_9236_(), index);
    }

    private static BackpackWrapper getBlockEntity(Inventory inventory, FriendlyByteBuf data) {
        BlockPos pos = data.m_130135_();
        BlockEntity blockEntityAtPos = inventory.f_35978_.m_9236_().m_7702_(pos);
        if (blockEntityAtPos instanceof BackpackBlockEntity) {
            BackpackBlockEntity backpackBlockEntity = (BackpackBlockEntity)blockEntityAtPos;
            backpackBlockEntity.getWrapper().addUser(inventory.f_35978_);
            backpackBlockEntity.getWrapper().setBackpackPos(pos);
            backpackBlockEntity.setSettingsUser(inventory.f_35978_);
            return backpackBlockEntity.getWrapper();
        }
        throw new IllegalStateException("Block Entity is not correct! " + String.valueOf(blockEntityAtPos));
    }
}

