/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades;

import com.tiviacz.travelersbackpack.inventory.upgrades.UpgradeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public abstract class FilterSettingsBase<T extends UpgradeBase<T>> {
    protected List<ItemStack> filterItems;
    protected List<Integer> filterSettings;
    protected ItemStackHandler storage;
    private final int slotLimit;

    public FilterSettingsBase(ItemStackHandler storage, List<ItemStack> items, List<Integer> filterSettings, int slotLimit) {
        this.filterItems = items;
        this.filterSettings = filterSettings;
        this.storage = storage;
        this.slotLimit = slotLimit;
    }

    public abstract boolean matchesFilter(@Nullable Player var1, ItemStack var2);

    public List<Integer> getSettings() {
        return this.filterSettings;
    }

    public boolean compareModId(ItemStack stack, ItemStack other) {
        return stack.m_41720_().getCreatorModId(stack).equals(other.m_41720_().getCreatorModId(other));
    }

    public Stream<ItemStack> streamStorageContents() {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (int i = 0; i < this.storage.getSlots(); ++i) {
            if (this.storage.getStackInSlot(i).m_41619_()) continue;
            arrayList.add(this.storage.getStackInSlot(i));
        }
        return arrayList.stream();
    }

    public void updateFilter(@Nullable List<ItemStack> items) {
        if (items == null) {
            return;
        }
        this.filterItems = items.stream().limit(this.slotLimit).filter(stack -> !stack.m_41619_()).toList();
    }

    public void updateSettings(List<Integer> settings) {
        this.filterSettings = settings;
    }
}

