/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.List;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.Powah;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Blcks;
import owmii.powah.block.Tier;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.compat.emi.CoolantEmiRecipe;
import owmii.powah.compat.emi.EnergizingEmiRecipe;
import owmii.powah.compat.emi.HeatSourceEmiRecipe;
import owmii.powah.compat.emi.MagmatorEmiRecipe;
import owmii.powah.compat.emi.SolidCoolantEmiRecipe;
import owmii.powah.item.Itms;
import owmii.powah.lib.client.screen.container.AbstractContainerScreen;
import owmii.powah.recipe.Recipes;

@EmiEntrypoint
public class PowahEMIPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory MAGMATOR_CATEGORY = new EmiRecipeCategory(new ResourceLocation("powah", "magmatic"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)Blcks.MAGMATOR.get(Tier.BASIC)))){

        public Component getName() {
            return Component.m_237115_((String)"gui.powah.jei.category.magmatic");
        }
    };
    public static final EmiRecipeCategory COOLANT_CATEGORY = new EmiRecipeCategory(new ResourceLocation("powah", "coolants"), (EmiRenderable)EmiStack.of((ItemLike)Items.f_42447_)){

        public Component getName() {
            return Component.m_237115_((String)"gui.powah.jei.category.coolant");
        }
    };
    public static final EmiRecipeCategory SOLID_COOLANT_CATEGORY = new EmiRecipeCategory(new ResourceLocation("powah", "solid_coolants"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)Blcks.DRY_ICE.get()))){

        public Component getName() {
            return Component.m_237115_((String)"gui.powah.jei.category.solid.coolant");
        }
    };
    public static final EmiRecipeCategory HEAT_SOURCE_CATEGORY = new EmiRecipeCategory(new ResourceLocation("powah", "heat_sources"), (EmiRenderable)EmiStack.of((ItemLike)Blocks.f_50450_)){

        public Component getName() {
            return Component.m_237115_((String)"gui.powah.jei.category.heat.sources");
        }
    };
    public static final EmiRecipeCategory ENERGIZING_CATEGORY = new EmiRecipeCategory(new ResourceLocation("powah", "energizing"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)Blcks.ENERGIZING_ORB.get()))){

        public Component getName() {
            return Component.m_237115_((String)"gui.powah.jei.category.energizing");
        }
    };

    public void register(EmiRegistry registry) {
        registry.addCategory(MAGMATOR_CATEGORY);
        registry.addCategory(COOLANT_CATEGORY);
        registry.addCategory(SOLID_COOLANT_CATEGORY);
        registry.addCategory(HEAT_SOURCE_CATEGORY);
        registry.addCategory(ENERGIZING_CATEGORY);
        registry.addWorkstation(ENERGIZING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)Blcks.ENERGIZING_ORB.get())));
        Blcks.ENERGIZING_ROD.getAll().forEach(block -> registry.addWorkstation(ENERGIZING_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block)));
        Blcks.MAGMATOR.getAll().forEach(block -> registry.addWorkstation(MAGMATOR_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block)));
        Blcks.THERMO_GENERATOR.getAll().forEach(block -> {
            registry.addWorkstation(HEAT_SOURCE_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
            registry.addWorkstation(COOLANT_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
        });
        Blcks.REACTOR.getAll().forEach(block -> {
            registry.addWorkstation(SOLID_COOLANT_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
            registry.addWorkstation(COOLANT_CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
        });
        RecipeManager manager = registry.getRecipeManager();
        manager.m_44013_(Recipes.ENERGIZING.get()).forEach(r -> registry.addRecipe((EmiRecipe)new EnergizingEmiRecipe((EnergizingRecipe)r)));
        BuiltInRegistries.f_257020_.m_6579_().forEach(f -> {
            Integer heat_source;
            Integer coldness;
            ResourceLocation fluidId = ((ResourceKey)f.getKey()).m_135782_();
            Integer magmatic_heat = PowahAPI.MAGMATIC_FLUIDS.get(fluidId);
            if (magmatic_heat != null) {
                registry.addRecipe((EmiRecipe)new MagmatorEmiRecipe((Fluid)f.getValue(), magmatic_heat));
            }
            if ((coldness = PowahAPI.COOLANT_FLUIDS.get(fluidId)) != null) {
                registry.addRecipe((EmiRecipe)new CoolantEmiRecipe((Fluid)f.getValue(), coldness));
            }
            if ((heat_source = PowahAPI.HEAT_SOURCES.getOrDefault(fluidId, 0)) != 0) {
                registry.addRecipe((EmiRecipe)new HeatSourceEmiRecipe((EmiIngredient)EmiStack.of((Fluid)((Fluid)f.getValue())), heat_source));
            }
        });
        BuiltInRegistries.f_257033_.m_6579_().forEach(i -> {
            BlockItem blockItem;
            Block block;
            ResourceLocation blockId;
            Integer heat;
            Object patt5103$temp;
            ResourceLocation id = ((ResourceKey)i.getKey()).m_135782_();
            Pair<Integer, Integer> coolantInfo = PowahAPI.SOLID_COOLANTS.get(id);
            if (coolantInfo != null) {
                registry.addRecipe((EmiRecipe)new SolidCoolantEmiRecipe((Item)i.getValue(), (Integer)coolantInfo.getLeft(), (Integer)coolantInfo.getRight()));
            }
            if ((patt5103$temp = i.getValue()) instanceof BlockItem && (heat = PowahAPI.HEAT_SOURCES.getOrDefault(blockId = BuiltInRegistries.f_256975_.m_7981_((Object)(block = (blockItem = (BlockItem)patt5103$temp).m_40614_())), 0)) != 0) {
                registry.addRecipe((EmiRecipe)new HeatSourceEmiRecipe((EmiIngredient)EmiStack.of((ItemLike)blockItem), heat));
            }
        });
        if (Powah.config().general.player_aerial_pearl) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.PLAYER_AERIAL_PEARL.get()))), List.of(Component.m_237115_((String)"jei.powah.player_aerial_pearl")), null));
        }
        if (Powah.config().general.dimensional_binding_card) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.BINDING_CARD_DIM.get()))), List.of(Component.m_237115_((String)"jei.powah.binding_card_dim")), null));
        }
        if (Powah.config().general.lens_of_ender) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.LENS_OF_ENDER.get()))), List.of(Component.m_237115_((String)"jei.powah.lens_of_ender")), null));
        }
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                for (Rect2i area : containerScreen.getExtraAreas()) {
                    consumer.accept(new Bounds(area.m_110085_(), area.m_110086_(), area.m_110090_(), area.m_110091_()));
                }
            }
        });
    }
}

