/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.wiki;

import dev.architectury.event.events.client.ClientRecipeUpdateEvent;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.lib.client.wiki.Entry;
import owmii.powah.lib.client.wiki.Icon;

public class Wiki {
    public static final Marker MARKER = new MarkerManager.Log4jMarker("Wiki");
    public static final Map<String, Wiki> WIKIS = new HashMap<String, Wiki>();
    private final List<Entry> categories = new ArrayList<Entry>();
    private final Map<ItemLike, List<Recipe<?>>> crafting = new HashMap();
    private final Map<ItemLike, List<Recipe<?>>> smelting = new HashMap();
    private final String modId;

    public Wiki() {
        this.modId = "powah";
        WIKIS.put(this.modId, this);
    }

    public Wiki e(String name, Consumer<Entry> consumer) {
        return this.e(name, null, consumer);
    }

    public Wiki e(String name, @Nullable Icon icon, Consumer<Entry> consumer) {
        Entry entry = new Entry(name, icon, this);
        entry.setMain(true);
        entry.setParent(entry);
        consumer.accept(entry);
        this.register(entry);
        return this;
    }

    public Entry register(Entry entry) {
        this.categories.add(entry);
        return entry;
    }

    public List<Entry> getCategories() {
        return this.categories;
    }

    public Map<ItemLike, List<Recipe<?>>> getCrafting() {
        return this.crafting;
    }

    public Map<ItemLike, List<Recipe<?>>> getSmelting() {
        return this.smelting;
    }

    public String getModId() {
        return this.modId;
    }

    public String getModName() {
        return Platform.getMod((String)this.modId).getName();
    }

    public String getModVersion() {
        return Platform.getMod((String)this.modId).getVersion();
    }

    static {
        ClientRecipeUpdateEvent.EVENT.register(recipeManager -> {
            RegistryAccess registryAccess = Minecraft.m_91087_().f_91073_.m_9598_();
            StopWatch watch = StopWatch.createStarted();
            Powah.LOGGER.info(MARKER, "Started wikis recipes collecting...");
            WIKIS.forEach((s, wiki) -> BuiltInRegistries.f_257033_.m_123024_().filter(i -> BuiltInRegistries.f_257033_.m_7981_(i).m_135827_().equals("powah")).forEach(item -> {
                ArrayList crafting = new ArrayList();
                recipeManager.m_44013_(RecipeType.f_44107_).forEach(recipe -> {
                    if (recipe.m_8043_(registryAccess).m_150930_(item)) {
                        crafting.add(recipe);
                    }
                });
                wiki.crafting.put((ItemLike)item, crafting);
                ArrayList smelting = new ArrayList();
                recipeManager.m_44013_(RecipeType.f_44107_).forEach(recipe -> {
                    if (recipe.m_8043_(registryAccess).m_150930_(item)) {
                        smelting.add(recipe);
                    }
                });
                wiki.smelting.put((ItemLike)item, smelting);
            }));
            watch.stop();
            Powah.LOGGER.info(MARKER, "Wiki recipes collecting completed in : {} ms", (Object)watch.getTime());
        });
    }
}

