/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.BlockPocketBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.blocks.BlockPocketWallBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedCrystalQuartzPillar;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedRotatedPillarBlock;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.inventory.InsertOnlyItemStackHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPocketManagerBlockEntity
extends CustomizableBlockEntity
implements MenuProvider,
ITickingBlockEntity,
ILockable {
    public static final int RENDER_DISTANCE = 100;
    private static final int BLOCK_PLACEMENTS_PER_TICK = 4;
    private boolean enabled = false;
    private boolean showOutline = false;
    private int color = -16776961;
    private int size = 5;
    private int autoBuildOffset = 0;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();
    protected NonNullList<ItemStack> storage = NonNullList.m_122780_((int)56, (Object)ItemStack.f_41583_);
    private LazyOptional<IItemHandler> storageHandler;
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private List<Pair<BlockPos, BlockState>> placeQueue = new ArrayList<Pair<BlockPos, BlockState>>();
    private boolean shouldPlaceBlocks = false;

    public BlockPocketManagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.shouldPlaceBlocks) {
            Object owner = PlayerUtils.getPlayerFromName(this.getOwner().getName());
            if (owner == null) {
                this.placeQueue.clear();
                this.shouldPlaceBlocks = false;
                return;
            }
            boolean isCreative = owner.m_7500_();
            boolean placed4Blocks = true;
            block0: for (int i = 0; i < 4; ++i) {
                Pair<BlockPos, BlockState> toPlace;
                BlockState stateInLevel;
                do {
                    if (this.placeQueue.isEmpty()) {
                        placed4Blocks = false;
                        break block0;
                    }
                    toPlace = this.placeQueue.remove(0);
                    if (((BlockState)toPlace.getRight()).m_60734_() instanceof IBlockPocket) continue;
                    throw new IllegalStateException(String.format("Tried to automatically place non-block pocket block \"%s\"! This mustn't happen!", ((BlockState)toPlace.getRight()).m_60734_().m_7705_()));
                } while ((stateInLevel = level.m_8055_((BlockPos)toPlace.getLeft())) == toPlace.getRight());
                if (stateInLevel.m_247087_()) {
                    BlockPos placeLocation = (BlockPos)toPlace.getLeft();
                    BlockState stateToPlace = (BlockState)toPlace.getRight();
                    SoundType soundType = stateToPlace.m_60827_();
                    if (!isCreative) {
                        for (int k = 0; k < this.storage.size(); ++k) {
                            ItemStack stackToCheck = (ItemStack)this.storage.get(k);
                            if (stackToCheck.m_41619_() || ((BlockItem)stackToCheck.m_41720_()).m_40614_() != stateToPlace.m_60734_()) continue;
                            stackToCheck.m_41774_(1);
                            break;
                        }
                    }
                    level.m_46597_(placeLocation, stateToPlace);
                    level.m_5594_(null, placeLocation, soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
                    level.m_142346_(null, GameEvent.f_157797_, placeLocation);
                    BlockEntity placedBe = level.m_7702_(placeLocation);
                    if (!(placedBe instanceof OwnableBlockEntity)) continue;
                    OwnableBlockEntity ownable = (OwnableBlockEntity)placedBe;
                    ownable.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
                    continue;
                }
                PlayerUtils.sendMessageToPlayer(owner, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).m_7705_(), new Object[0]), Component.m_237110_((String)"messages.securitycraft:blockpocket.assemblyFailed", (Object[])new Object[]{this.getFormattedRelativeCoordinates((BlockPos)toPlace.getLeft(), (Direction)state.m_61143_((Property)BlockPocketManagerBlock.FACING)), Component.m_237115_((String)stateInLevel.m_60734_().m_7705_())}), ChatFormatting.DARK_AQUA);
                placed4Blocks = false;
                break;
            }
            if (!placed4Blocks) {
                if (!this.placeQueue.isEmpty()) {
                    this.placeQueue.clear();
                } else {
                    this.setWalls(!this.isModuleEnabled(ModuleType.DISGUISE));
                    PlayerUtils.sendMessageToPlayer(owner, Utils.localize(((BlockPocketManagerBlock)((Object)SCContent.BLOCK_POCKET_MANAGER.get())).m_7705_(), new Object[0]), Component.m_237115_((String)"messages.securitycraft:blockpocket.assembled"), ChatFormatting.DARK_AQUA);
                }
                this.shouldPlaceBlocks = false;
            }
        }
    }

    public MutableComponent enableMultiblock() {
        if (this.f_58857_.f_46443_) {
            return Component.m_237115_((String)"enableMultiblock called on client! Send a ToggleBlockPocketManager packet instead.");
        }
        if (!this.isEnabled()) {
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
            Direction managerFacing = (Direction)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.m_122427_();
            Direction right = left.m_122424_();
            Direction back = left.m_122427_();
            boolean lowest = false;
            int highest = this.getSize() - 1;
            BlockPos pos = this.m_58899_().m_7949_();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int offset = 0;
            if (!(this.f_58857_.m_8055_(pos.m_121945_(left)).m_60734_() instanceof IBlockPocket)) {
                offset = -this.getAutoBuildOffset() + this.getSize() / 2;
                pos = pos.m_5484_(left, offset);
            } else {
                for (int i = 1; i < this.getSize() - 1; ++i) {
                    if (this.f_58857_.m_8055_(pos.m_5484_(left, i)).m_60734_() instanceof ReinforcedRotatedCrystalQuartzPillar) continue;
                    offset = i;
                    pos = pos.m_5484_(left, offset);
                    break;
                }
                if (offset == 0) {
                    offset = -this.getAutoBuildOffset() + this.getSize() / 2;
                    pos = pos.m_5484_(left, offset);
                }
            }
            BlockPos startingPos = pos.m_7949_();
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.m_5484_(right, xi);
                        BlockState currentState = this.f_58857_.m_8055_(currentPos);
                        if (currentState.m_60734_() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.m_58899_())) {
                            return Component.m_237115_((String)"messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.m_60734_() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((BlockPocketBlock)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).m_7705_())});
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                    }
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                        return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                    }
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock)) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).m_7705_())});
                                }
                                floor.add(currentPos);
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() || currentState.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y) {
                                if (currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock.rotation", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_7705_())});
                            }
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            if (!(currentState.m_60734_() instanceof BlockPocketWallBlock)) {
                                return Component.m_237110_((String)"messages.securitycraft:blockpocket.invalidBlock", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_()), Component.m_237115_((String)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).m_7705_())});
                            }
                            sides.add(currentPos);
                        }
                        if (!this.getOwner().owns((OwnableBlockEntity)this.f_58857_.m_7702_(currentPos))) {
                            return Component.m_237110_((String)"messages.securitycraft:blockpocket.unowned", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.floor = floor;
            this.setEnabled(true);
            this.setAutoBuildOffset(-offset + this.getSize() / 2);
            this.m_6596_();
            for (BlockPos blockPos : blocks) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.setManager(this);
            }
            for (BlockPos blockPos : floor) {
                this.f_58857_.m_46597_(blockPos, (BlockState)this.f_58857_.m_8055_(blockPos).m_61124_((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(true)));
            }
            this.setWalls(!this.isModuleEnabled(ModuleType.DISGUISE));
            return Component.m_237115_((String)"messages.securitycraft:blockpocket.activated");
        }
        return null;
    }

    public MutableComponent autoAssembleMultiblock() {
        if (this.f_58857_.f_46443_) {
            return Component.m_237115_((String)"autoAssembleMultiblock called on client! Send an AssembleBlockPocket packet instead.");
        }
        if (!this.isEnabled()) {
            BlockState currentState;
            BlockPos currentPos;
            Direction managerFacing = (Direction)this.m_58900_().m_61143_((Property)BlockPocketManagerBlock.FACING);
            Direction left = managerFacing.m_122427_();
            Direction right = left.m_122424_();
            Direction back = left.m_122427_();
            boolean lowest = false;
            int half = (this.getSize() - 1) / 2 - this.getAutoBuildOffset();
            int highest = this.getSize() - 1;
            BlockPos pos = this.m_58899_().m_7949_();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.m_5484_(right, -half);
            BlockPos startingPos = pos.m_7949_();
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        BlockEntity blockEntity;
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.m_5484_(right, xi);
                        currentState = this.f_58857_.m_8055_(currentPos);
                        boolean replaceable = currentState.m_247087_();
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.m_60734_() != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() && !replaceable) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                Direction.Axis axis = typeToCheckFor = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != typeToCheckFor) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.m_60734_() instanceof BlockPocketWallBlock) && !replaceable) {
                                    return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                                }
                                if (replaceable) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.m_60734_() != SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && !replaceable || currentState.m_60734_() == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get() && currentState.m_61143_((Property)BlockStateProperties.f_61365_) != Direction.Axis.Y) {
                                return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                            }
                            if (replaceable) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            if (!(currentState.m_60734_() instanceof BlockPocketWallBlock) && !replaceable) {
                                return Component.m_237110_((String)"messages.securitycraft:blockpocket.blockInWay", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                            }
                            if (replaceable) {
                                ++wallsNeeded;
                            }
                        }
                        if ((blockEntity = this.f_58857_.m_7702_(currentPos)) instanceof OwnableBlockEntity) {
                            OwnableBlockEntity be = (OwnableBlockEntity)blockEntity;
                            if (!this.getOwner().owns(be)) {
                                return Component.m_237110_((String)"messages.securitycraft:blockpocket.unowned", (Object[])new Object[]{this.getFormattedRelativeCoordinates(currentPos, managerFacing), Component.m_237115_((String)currentState.m_60734_().m_5456_().m_5524_())});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return Component.m_237115_((String)"messages.securitycraft:blockpocket.alreadyAssembled");
            }
            pos = this.m_58899_().m_7949_().m_5484_(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.getSize()) {
                while (zi < this.getSize()) {
                    while (xi < this.getSize()) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        currentPos = pos.m_5484_(right, xi);
                        currentState = this.f_58857_.m_8055_(currentPos);
                        if (currentState.m_60734_() instanceof BlockPocketManagerBlock && !currentPos.equals((Object)this.m_58899_())) {
                            return Component.m_237115_((String)"messages.securitycraft:blockpocket.multipleManagers");
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.m_58899_()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketBlock)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()).m_49966_()));
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.X : Direction.Axis.Z;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                typeToPlace = managerFacing == Direction.NORTH || managerFacing == Direction.SOUTH ? Direction.Axis.Z : Direction.Axis.X;
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)typeToPlace))));
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).m_49966_()));
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockState)((ReinforcedRotatedCrystalQuartzPillar)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()).m_49966_().m_61124_(ReinforcedRotatedPillarBlock.AXIS, (Comparable)Direction.Axis.Y))));
                        } else if (yi > 0 && yi < highest && ((zi == 0 || zi == highest) && xi > 0 && xi < highest || (xi == 0 || xi == highest) && zi > 0 && zi < highest)) {
                            this.placeQueue.add((Pair<BlockPos, BlockState>)Pair.of((Object)currentPos, (Object)((BlockPocketWallBlock)SCContent.BLOCK_POCKET_WALL.get()).m_49966_()));
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.m_6630_(yi).m_5484_(back, ++zi);
                }
                zi = 0;
                pos = startingPos.m_6630_(++yi);
            }
            this.shouldPlaceBlocks = true;
            return null;
        }
        return null;
    }

    public MutableComponent disableMultiblock() {
        if (this.f_58857_.f_46443_) {
            return Component.m_237115_((String)"disableMultiblock called on client! Send a ToggleBlockPocketManager packet instead.");
        }
        if (this.isEnabled()) {
            this.setEnabled(false);
            for (BlockPos pos : this.blocks) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (!(blockEntity instanceof BlockPocketBlockEntity)) continue;
                BlockPocketBlockEntity be = (BlockPocketBlockEntity)blockEntity;
                be.removeManager();
            }
            for (BlockPos pos : this.floor) {
                BlockState state = this.f_58857_.m_8055_(pos);
                if (!state.m_61138_((Property)BlockPocketWallBlock.SOLID)) continue;
                this.f_58857_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockPocketWallBlock.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.isModuleEnabled(ModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
            this.m_6596_();
            return Utils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]);
        }
        return null;
    }

    private Component getFormattedRelativeCoordinates(BlockPos pos, Direction managerFacing) {
        int offsetBehind;
        BlockPos difference = pos.m_121996_((Vec3i)this.f_58858_);
        int offsetAbove = difference.m_123342_();
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        int offsetLeft = switch (managerFacing) {
            case Direction.NORTH -> {
                offsetBehind = difference.m_123343_();
                yield difference.m_123341_();
            }
            case Direction.SOUTH -> {
                offsetBehind = -difference.m_123343_();
                yield -difference.m_123341_();
            }
            case Direction.WEST -> {
                offsetBehind = difference.m_123341_();
                yield -difference.m_123343_();
            }
            case Direction.EAST -> {
                offsetBehind = -difference.m_123341_();
                yield difference.m_123343_();
            }
            default -> throw new IllegalArgumentException("Invalid Block Pocket Manager direction: " + managerFacing.name());
        };
        if (offsetLeft > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksLeft", offsetLeft));
        } else if (offsetLeft < 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksRight", -offsetLeft));
        }
        if (offsetBehind > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksBehind", offsetBehind));
        }
        if (offsetAbove > 0) {
            components.add(Utils.localize("messages.securitycraft:blockpocket.position.blocksAbove", offsetAbove));
        }
        return Utils.localize("messages.securitycraft:blockpocket.position." + components.size(), components.toArray());
    }

    public void toggleOutline() {
        this.setShowOutline(!this.showsOutline());
        this.m_6596_();
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            BlockState state = this.f_58857_.m_8055_(pos);
            if (!(state.m_60734_() instanceof BlockPocketWallBlock)) continue;
            this.f_58857_.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockPocketWallBlock.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return !this.isPlacingBlocks() && BlockUtils.isAllowedToExtractFromProtectedObject(side, this) ? this.getStorageHandler().cast() : this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.storageHandler != null) {
            this.storageHandler.invalidate();
        }
        if (this.insertOnlyHandler != null) {
            this.insertOnlyHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.storageHandler = null;
        this.insertOnlyHandler = null;
        super.reviveCaps();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.m_46749_(this.f_58858_) && this.f_58857_.m_8055_(this.f_58858_).m_60734_() != SCContent.BLOCK_POCKET_MANAGER.get()) {
            this.disableMultiblock();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (this.isEnabled() && module == ModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (this.isEnabled() && module == ModuleType.DISGUISE) {
            this.setWalls(true);
        } else if (module == ModuleType.STORAGE) {
            this.getStorageHandler().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)handler.getStackInSlot(i));
                }
            });
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        int i;
        tag.m_128379_("BlockPocketEnabled", this.isEnabled());
        tag.m_128379_("ShowOutline", this.showsOutline());
        tag.m_128405_("Size", this.getSize());
        tag.m_128405_("AutoBuildOffset", this.getAutoBuildOffset());
        tag.m_128405_("Color", this.color);
        ContainerHelper.m_18973_((CompoundTag)tag, this.storage);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.m_128356_("BlocksList" + i, this.blocks.get(i).m_121878_());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.m_128356_("WallsList" + i, this.walls.get(i).m_121878_());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.m_128356_("FloorList" + i, this.floor.get(i).m_121878_());
        }
        super.m_183515_(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        int i = 0;
        super.m_142466_(tag);
        this.setEnabled(tag.m_128471_("BlockPocketEnabled"));
        this.setShowOutline(tag.m_128471_("ShowOutline"));
        this.setSize(tag.m_128451_("Size"));
        this.setAutoBuildOffset(tag.m_128451_("AutoBuildOffset"));
        this.setColor(tag.m_128451_("Color"));
        ContainerHelper.m_18980_((CompoundTag)tag, this.storage);
        while (tag.m_128441_("BlocksList" + i)) {
            this.blocks.add(BlockPos.m_122022_((long)tag.m_128454_("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.m_128441_("WallsList" + i)) {
            this.walls.add(BlockPos.m_122022_((long)tag.m_128454_("WallsList" + i)));
            ++i;
        }
        i = 0;
        while (tag.m_128441_("FloorList" + i)) {
            this.floor.add(BlockPos.m_122022_((long)tag.m_128454_("FloorList" + i)));
            ++i;
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.ALLOWLIST, ModuleType.STORAGE};
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.getBaseModuleDescriptionId(denotation, module);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new BlockPocketManagerMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(100.0);
    }

    public LazyOptional<IItemHandler> getStorageHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = LazyOptional.of(() -> new ItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerBlockEntity.isItemValid(stack);
                }
            });
        }
        return this.storageHandler;
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyItemStackHandler(this.storage){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return BlockPocketManagerBlockEntity.isItemValid(stack);
                }
            });
        }
        return this.insertOnlyHandler;
    }

    public boolean isPlacingBlocks() {
        return this.shouldPlaceBlocks;
    }

    public static boolean isItemValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            return block == SCContent.BLOCK_POCKET_WALL.get() || block == SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get() || block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get();
        }
        return false;
    }

    public void setColor(int color) {
        this.color = Mth.m_14045_((int)color, (int)-16777216, (int)-1);
    }

    public int getColor() {
        return this.color;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setAutoBuildOffset(int autoBuildOffset) {
        this.autoBuildOffset = autoBuildOffset;
    }

    public int getAutoBuildOffset() {
        return this.autoBuildOffset;
    }

    public void setShowOutline(boolean showOutline) {
        this.showOutline = showOutline;
    }

    public boolean showsOutline() {
        return this.showOutline;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

