/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class OpenScreen {
    private DataType dataType;
    private BlockPos pos;
    private CompoundTag tag;
    private int entityId;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType) {
        this.dataType = dataType;
        if (dataType.needsPosition) {
            throw new IllegalArgumentException(String.format("The DataType %s needs a position, but none was supplied.", dataType.name()));
        }
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public OpenScreen(DataType dataType, CompoundTag tag) {
        this.dataType = dataType;
        this.tag = tag;
    }

    public OpenScreen(DataType dataType, int entityId) {
        this.dataType = dataType;
        this.entityId = entityId;
    }

    public OpenScreen(FriendlyByteBuf buf) {
        this.dataType = (DataType)buf.m_130066_(DataType.class);
        if (this.dataType.needsPosition) {
            this.pos = buf.m_130135_();
        } else if (this.dataType == DataType.SENTRY_REMOTE_ACCESS_TOOL) {
            this.tag = buf.m_130260_();
        } else if (this.dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || this.dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || this.dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
            this.entityId = buf.m_130242_();
        }
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.dataType);
        if (this.dataType.needsPosition) {
            buf.m_130064_(this.pos);
        } else if (this.dataType == DataType.SENTRY_REMOTE_ACCESS_TOOL) {
            buf.m_130079_(this.tag);
        } else if (this.dataType == DataType.CHANGE_PASSCODE_FOR_ENTITY || this.dataType == DataType.CHECK_PASSCODE_FOR_ENTITY || this.dataType == DataType.SET_PASSCODE_FOR_ENTITY) {
            buf.m_130130_(this.entityId);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Level level = ClientHandler.getClientLevel();
        switch (this.dataType) {
            case ALARM: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof AlarmBlockEntity)) break;
                AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
                ClientHandler.displayAlarmScreen(be);
                break;
            }
            case CHANGE_PASSCODE: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayUniversalKeyChangerScreen((BlockEntity)be);
                break;
            }
            case CHANGE_PASSCODE_FOR_ENTITY: {
                Entity entity = level.m_6815_(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity2 = (IPasscodeProtected)entity;
                ClientHandler.displayUniversalKeyChangerScreen((Entity)entity2);
                break;
            }
            case CHECK_PASSCODE: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displayCheckPasscodeScreen((BlockEntity)be);
                break;
            }
            case CHECK_PASSCODE_FOR_BRIEFCASE: {
                ItemStack briefcaseStack = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcaseStack.m_41619_()) break;
                ClientHandler.displayBriefcasePasscodeScreen(briefcaseStack.m_41786_());
                break;
            }
            case CHECK_PASSCODE_FOR_ENTITY: {
                Entity entity = level.m_6815_(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity3 = (IPasscodeProtected)entity;
                ClientHandler.displayCheckPasscodeScreen((Entity)entity3);
                break;
            }
            case RIFT_STABILIZER: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof RiftStabilizerBlockEntity)) break;
                RiftStabilizerBlockEntity riftStabilizer = (RiftStabilizerBlockEntity)blockEntity;
                ClientHandler.displayRiftStabilizerScreen(riftStabilizer);
                break;
            }
            case SECURE_REDSTONE_INTERFACE: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof SecureRedstoneInterfaceBlockEntity)) break;
                SecureRedstoneInterfaceBlockEntity secureRedstoneInterface = (SecureRedstoneInterfaceBlockEntity)blockEntity;
                ClientHandler.displaySecureRedstoneInterfaceScreen(secureRedstoneInterface);
                break;
            }
            case SENTRY_REMOTE_ACCESS_TOOL: {
                ItemStack srat = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get());
                if (srat.m_41619_()) break;
                srat.m_41751_(this.tag);
                ClientHandler.displaySRATScreen(srat);
                break;
            }
            case SET_PASSCODE: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof IPasscodeProtected)) break;
                IPasscodeProtected be = (IPasscodeProtected)blockEntity;
                ClientHandler.displaySetPasscodeScreen((BlockEntity)be);
                break;
            }
            case SET_PASSCODE_FOR_BRIEFCASE: {
                ItemStack briefcase = PlayerUtils.getItemStackFromAnyHand(ClientHandler.getClientPlayer(), (Item)SCContent.BRIEFCASE.get());
                if (briefcase.m_41619_()) break;
                ClientHandler.displayBriefcaseSetupScreen((Component)briefcase.m_41786_().m_6879_().m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Utils.localize("gui.securitycraft:passcode.setup", new Object[0])));
                break;
            }
            case SET_PASSCODE_FOR_ENTITY: {
                Entity entity = level.m_6815_(this.entityId);
                if (!(entity instanceof IPasscodeProtected)) break;
                IPasscodeProtected entity4 = (IPasscodeProtected)entity;
                ClientHandler.displaySetPasscodeScreen((Entity)entity4);
                break;
            }
            case SONIC_SECURITY_SYSTEM: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof SonicSecuritySystemBlockEntity)) break;
                SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)blockEntity;
                ClientHandler.displaySonicSecuritySystemScreen(sss);
                break;
            }
            case USERNAME_LOGGER: {
                BlockEntity blockEntity = level.m_7702_(this.pos);
                if (!(blockEntity instanceof UsernameLoggerBlockEntity)) break;
                UsernameLoggerBlockEntity logger = (UsernameLoggerBlockEntity)blockEntity;
                ClientHandler.displayUsernameLoggerScreen(logger);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data type: " + this.dataType.name());
            }
        }
    }

    public static enum DataType {
        ALARM(true),
        CHANGE_PASSCODE(true),
        CHANGE_PASSCODE_FOR_ENTITY(false),
        CHECK_PASSCODE(true),
        CHECK_PASSCODE_FOR_BRIEFCASE(false),
        CHECK_PASSCODE_FOR_ENTITY(false),
        RIFT_STABILIZER(true),
        SENTRY_REMOTE_ACCESS_TOOL(false),
        SECURE_REDSTONE_INTERFACE(true),
        SET_PASSCODE(true),
        SET_PASSCODE_FOR_BRIEFCASE(false),
        SET_PASSCODE_FOR_ENTITY(false),
        SONIC_SECURITY_SYSTEM(true),
        USERNAME_LOGGER(true);

        public final boolean needsPosition;

        private DataType(boolean needsPosition) {
            this.needsPosition = needsPosition;
        }
    }
}

