/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class SecurityCameraRenderer
implements BlockEntityRenderer<SecurityCameraBlockEntity> {
    private static final Quaternionf POSITIVE_Y_180 = Axis.f_252436_.m_252977_(180.0f);
    private static final Quaternionf POSITIVE_Y_90 = Axis.f_252436_.m_252977_(90.0f);
    private static final Quaternionf NEGATIVE_Y_90 = Axis.f_252392_.m_252977_(90.0f);
    private static final Quaternionf POSITIVE_X_180 = Axis.f_252529_.m_252977_(180.0f);
    public static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/entity/security_camera/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = new ResourceLocation("securitycraft", "textures/entity/security_camera/security_camera_viewing.png");
    private final SecurityCameraModel model;

    public SecurityCameraRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecurityCameraModel(ctx.m_173582_(ClientHandler.SECURITY_CAMERA_LOCATION));
    }

    public void render(SecurityCameraBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (FrameFeedHandler.amIBeingCaptured(be) || PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.m_91087_().f_91074_) && Minecraft.m_91087_().f_91075_.m_20183_().equals((Object)be.m_58899_())) {
            return;
        }
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryRenderDelegate(be, partialTicks, pose, buffer, packedLight, packedOverlay);
        if (be.isDown()) {
            return;
        }
        if (!be.isModuleEnabled(ModuleType.DISGUISE)) {
            DyeableLeatherItem item;
            BlockState state;
            pose.m_85837_(0.5, 1.5, 0.5);
            if (be.m_58898_() && (state = be.m_58904_().m_8055_(be.m_58899_())).m_60734_() == SCContent.SECURITY_CAMERA.get()) {
                Direction side = (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING);
                if (side == Direction.NORTH) {
                    pose.m_252781_(POSITIVE_Y_180);
                } else if (side == Direction.EAST) {
                    pose.m_252781_(POSITIVE_Y_90);
                } else if (side == Direction.WEST) {
                    pose.m_252781_(NEGATIVE_Y_90);
                }
            }
            pose.m_252781_(POSITIVE_X_180);
            this.model.rotateCameraY((float)Mth.m_14139_((double)partialTicks, (double)be.getOriginalCameraRotation(), (double)be.getCameraRotation()));
            if (be.isShutDown()) {
                this.model.rotateCameraX(0.9f);
            } else {
                this.model.rotateCameraX(0.2617994f);
            }
            ItemStack lens = be.getLensContainer().m_8020_(0);
            float r = 0.4392157f;
            float g = 1.0f;
            float b = 1.0f;
            Item item2 = lens.m_41720_();
            if (item2 instanceof DyeableLeatherItem && (item = (DyeableLeatherItem)item2).m_41113_(lens)) {
                int color = item.m_41121_(lens);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            } else {
                this.model.cameraRotationPoint2.f_104207_ = false;
            }
            this.model.m_7695_(pose, buffer.m_6299_(RenderType.m_110446_((ResourceLocation)((Boolean)be.m_58900_().m_61143_((Property)SecurityCameraBlock.BEING_VIEWED) != false ? BEING_VIEWED_TEXTURE : TEXTURE))), packedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
            this.model.cameraRotationPoint2.f_104207_ = true;
        }
    }
}

