/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.SmallButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class AlarmOptionsScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/alarm_options.png");
    private static final ResourceLocation RESET_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset.png");
    private static final ResourceLocation RESET_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/reset_inactive.png");
    private final Component soundLengthText = Component.m_237115_((String)"gui.securitycraft:alarm.sound_length").m_130940_(ChatFormatting.UNDERLINE);
    private final AlarmScreen alarmScreen;
    private int imageWidth = 226;
    private int imageHeight = 112;
    private int leftPos;
    private int topPos;
    private Button minusMinute;
    private Button minusTenSeconds;
    private Button minusSecond;
    private Button reset;
    private Button plusSecond;
    private Button plusTenSeconds;
    private Button plusMinute;
    private SoundLengthEditBox soundLengthEditBox;
    private int soundLengthTextXPosition;

    public AlarmOptionsScreen(AlarmScreen alarmScreen) {
        super((Component)Utils.localize("options.title", new Object[0]));
        this.alarmScreen = alarmScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        int buttonHeight = 13;
        int buttonsX = this.leftPos + 5;
        int buttonY = this.topPos + 40;
        int timeEditBoxWidth = 34;
        int soundLengthTextWidthPlusBuffer = this.f_96547_.m_92852_((FormattedText)this.soundLengthText) + 5;
        int combinedTextAndBoxWidth = soundLengthTextWidthPlusBuffer + timeEditBoxWidth;
        this.m_142416_((GuiEventListener)SmallButton.createWithX(this.leftPos + this.imageWidth - 12, this.topPos + 4, b -> Minecraft.m_91087_().popGuiLayer()));
        this.soundLengthTextXPosition = this.f_96543_ / 2 - combinedTextAndBoxWidth / 2;
        this.soundLengthEditBox = (SoundLengthEditBox)this.m_142416_((GuiEventListener)new SoundLengthEditBox(this.f_96547_, this.soundLengthTextXPosition + soundLengthTextWidthPlusBuffer, buttonY - 15, timeEditBoxWidth, 12, (Component)Component.m_237119_()));
        this.soundLengthEditBox.m_94153_(string -> string.matches("[0-9:]*"));
        this.minusMinute = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.minus_one_minute"), b -> this.changeSoundLength(-60), Button.f_252438_));
        this.minusTenSeconds = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX + 34, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.minus_ten_seconds"), b -> this.changeSoundLength(-10), Button.f_252438_));
        this.minusSecond = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX + 68, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.minus_one_second"), b -> this.changeSoundLength(-1), Button.f_252438_));
        this.reset = (Button)this.m_142416_((GuiEventListener)new ActiveBasedTextureButton(buttonsX + 102, buttonY, 12, buttonHeight, RESET_TEXTURE, RESET_INACTIVE_TEXTURE, 10, 10, 1, 2, 10, 10, 10, 10, b -> this.changeSoundLength(0)));
        this.plusSecond = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX + 116, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.plus_one_second"), b -> this.changeSoundLength(1), Button.f_252438_));
        this.plusTenSeconds = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX + 150, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.plus_ten_seconds"), b -> this.changeSoundLength(10), Button.f_252438_));
        this.plusMinute = (Button)this.m_142416_((GuiEventListener)new Button(buttonsX + 184, buttonY, 32, buttonHeight, (Component)Component.m_237115_((String)"gui.securitycraft:alarm.plus_one_minute"), b -> this.changeSoundLength(60), Button.f_252438_));
        this.setSoundLength(this.alarmScreen.soundLength);
        ((CallbackSlider)this.m_142416_((GuiEventListener)new CallbackSlider(this.leftPos + this.imageWidth / 2 - 50, buttonY + 25, 100, 20, (Component)Utils.localize("gui.securitycraft:alarm.pitch", ""), (Component)Component.m_237119_(), 0.5, 2.0, this.alarmScreen.pitch, 0.05, 0, true, slider -> {
            this.alarmScreen.pitch = (float)slider.getValue();
        }))).setFGColor(0xE0E0E0);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.topPos + 6, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.soundLengthText, this.soundLengthTextXPosition, this.topPos + 27, 0x404040, false);
        if (this.alarmScreen.be.isPowered() && !this.alarmScreen.be.isDisabled()) {
            int cooldownSeconds = (this.alarmScreen.be.getCooldown() - 1) / 20;
            MutableComponent nextSoundText = Utils.localize("gui.securitycraft:alarm.nextSound", String.format("%02d:%02d", cooldownSeconds / 60, cooldownSeconds % 60 + 1));
            guiGraphics.m_280614_(this.f_96547_, (Component)nextSoundText, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)nextSoundText) / 2, this.topPos + 95, 0x404040, false);
        }
    }

    public void setSoundLength(int newSoundLength) {
        this.setSoundLength(newSoundLength, true);
    }

    public void changeSoundLength(int soundLengthChange) {
        if (soundLengthChange == 0) {
            this.setSoundLength(this.alarmScreen.previousSoundLength, true);
        } else {
            this.setSoundLength(this.alarmScreen.soundLength + soundLengthChange, true);
        }
    }

    public void setSoundLength(int newSoundLength, boolean updateTimeEditBox) {
        boolean enableMinusButtons;
        int soundLength = Mth.m_14045_((int)newSoundLength, (int)1, (int)3600);
        if (updateTimeEditBox) {
            this.soundLengthEditBox.m_94144_(String.format("%02d:%02d", soundLength / 60, soundLength % 60));
        }
        boolean enablePlusButtons = soundLength < 3600;
        this.minusMinute.f_93623_ = enableMinusButtons = soundLength > 1;
        this.minusTenSeconds.f_93623_ = enableMinusButtons;
        this.minusSecond.f_93623_ = enableMinusButtons;
        this.reset.f_93623_ = soundLength != this.alarmScreen.previousSoundLength;
        this.plusSecond.f_93623_ = enablePlusButtons;
        this.plusTenSeconds.f_93623_ = enablePlusButtons;
        this.plusMinute.f_93623_ = enablePlusButtons;
        this.alarmScreen.soundLength = soundLength;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        this.soundLengthEditBox.checkAndProcessInput();
        super.m_7379_();
    }

    public boolean m_7043_() {
        return this.alarmScreen.m_7043_();
    }

    public class SoundLengthEditBox
    extends EditBox {
        public SoundLengthEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            AlarmOptionsScreen.this.changeSoundLength((int)Math.signum(delta));
            return super.m_6050_(mouseX, mouseY, delta);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257 || keyCode == 335) {
                this.checkAndProcessInput();
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public void m_93692_(boolean focused) {
            if (this.m_93696_() && !focused) {
                this.checkAndProcessInput();
            }
            super.m_93692_(focused);
        }

        public void checkAndProcessInput() {
            int minutes = 0;
            int seconds = 2;
            if (this.f_94093_ != null && !this.f_94093_.isEmpty() && !this.f_94093_.isBlank()) {
                if (!this.f_94093_.contains(":")) {
                    int numeric = Integer.parseInt(this.f_94093_);
                    minutes = numeric / 60;
                    seconds = numeric % 60;
                } else {
                    String[] split = this.f_94093_.split(":");
                    if (split.length == 2) {
                        if (!split[0].isEmpty() && !split[0].isBlank()) {
                            try {
                                minutes = Integer.parseInt(split[0]);
                            }
                            catch (NumberFormatException e) {
                                minutes = 60;
                            }
                        }
                        if (!split[1].isEmpty() && !split[1].isBlank()) {
                            try {
                                seconds = Integer.parseInt(split[1]);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else {
                            seconds = 0;
                        }
                    }
                }
            }
            AlarmOptionsScreen.this.setSoundLength(minutes * 60 + seconds, true);
            this.m_94201_();
        }
    }
}

