/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CheckPasscodeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/check_passcode.png");
    private static final Component COOLDOWN_TEXT_1 = Component.m_237115_((String)"gui.securitycraft:passcode.cooldown1");
    private int cooldownText1XPos;
    private IPasscodeProtected passcodeProtected;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private int imageWidth = 176;
    private int imageHeight = 186;
    private int leftPos;
    private int topPos;
    private CensoringEditBox keycodeTextbox;
    private boolean wasOnCooldownLastRenderTick = false;

    public CheckPasscodeScreen(IPasscodeProtected passcodeProtected, Component title) {
        super(title);
        this.passcodeProtected = passcodeProtected;
    }

    public void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.cooldownText1XPos = this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)COOLDOWN_TEXT_1) / 2;
        this.m_142416_((GuiEventListener)new CallbackCheckbox(this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 55, 12, 12, (Component)Component.m_237115_((String)"gui.securitycraft:passcode.showPasscode"), false, newState -> this.keycodeTextbox.setCensoring(newState == false), 0x404040));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 33, this.f_96544_ / 2 - 35, 20, 20, (Component)Component.m_237113_((String)"1"), b -> this.addNumberToString(1), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 35, 20, 20, (Component)Component.m_237113_((String)"2"), b -> this.addNumberToString(2), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 17, this.f_96544_ / 2 - 35, 20, 20, (Component)Component.m_237113_((String)"3"), b -> this.addNumberToString(3), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 33, this.f_96544_ / 2 - 10, 20, 20, (Component)Component.m_237113_((String)"4"), b -> this.addNumberToString(4), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 8, this.f_96544_ / 2 - 10, 20, 20, (Component)Component.m_237113_((String)"5"), b -> this.addNumberToString(5), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 17, this.f_96544_ / 2 - 10, 20, 20, (Component)Component.m_237113_((String)"6"), b -> this.addNumberToString(6), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 33, this.f_96544_ / 2 + 15, 20, 20, (Component)Component.m_237113_((String)"7"), b -> this.addNumberToString(7), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 15, 20, 20, (Component)Component.m_237113_((String)"8"), b -> this.addNumberToString(8), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 17, this.f_96544_ / 2 + 15, 20, 20, (Component)Component.m_237113_((String)"9"), b -> this.addNumberToString(9), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 33, this.f_96544_ / 2 + 40, 20, 20, (Component)Component.m_237113_((String)"\u2190"), b -> this.removeLastCharacter(), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 8, this.f_96544_ / 2 + 40, 20, 20, (Component)Component.m_237113_((String)"0"), b -> this.addNumberToString(0), Button.f_252438_));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 17, this.f_96544_ / 2 + 40, 20, 20, (Component)Component.m_237113_((String)"\u2714"), b -> this.checkCode(this.keycodeTextbox.m_94155_()), Button.f_252438_));
        this.keycodeTextbox = (CensoringEditBox)this.m_142416_((GuiEventListener)new CensoringEditBox(this.f_96547_, this.f_96543_ / 2 - 37, this.f_96544_ / 2 - 72, 77, 12, (Component)Component.m_237119_()){

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                return this.f_93623_ && super.m_6375_(mouseX, mouseY, button);
            }

            public boolean m_94204_() {
                return this.f_93623_ && this.m_94213_();
            }
        });
        this.keycodeTextbox.m_94199_(Integer.MAX_VALUE);
        this.keycodeTextbox.m_94153_(s -> s.matches("\\d*\\**"));
        if (this.passcodeProtected.isOnCooldown()) {
            this.toggleChildrenActive(false);
        } else {
            this.m_264313_((GuiEventListener)this.keycodeTextbox);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.topPos + 6, 0x404040, false);
        if (this.passcodeProtected.isOnCooldown()) {
            long cooldownEnd = this.passcodeProtected.getCooldownEnd();
            long secondsLeft = Math.max(cooldownEnd - System.currentTimeMillis(), 0L) / 1000L + 1L;
            MutableComponent text = Component.m_237110_((String)"gui.securitycraft:passcode.cooldown2", (Object[])new Object[]{secondsLeft});
            guiGraphics.m_280614_(this.f_96547_, COOLDOWN_TEXT_1, this.cooldownText1XPos, this.f_96544_ / 2 + 65, 0x404040, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)text, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)text) / 2, this.f_96544_ / 2 + 75, 0x404040, false);
            if (!this.wasOnCooldownLastRenderTick) {
                this.wasOnCooldownLastRenderTick = true;
            }
        } else if (this.wasOnCooldownLastRenderTick) {
            this.wasOnCooldownLastRenderTick = false;
            this.toggleChildrenActive(true);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && !this.keycodeTextbox.m_94155_().isEmpty()) {
            this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.15f, 1.0f);
        }
        if (!super.m_7933_(keyCode, scanCode, modifiers) && !this.keycodeTextbox.m_7933_(keyCode, scanCode, modifiers)) {
            if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
                this.m_7379_();
            }
            if (!(this.passcodeProtected.isOnCooldown() || keyCode != 257 && keyCode != 335)) {
                this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.15f, 1.0f);
                this.checkCode(this.keycodeTextbox.m_94155_());
            }
        }
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_5534_(char typedChar, int keyCode) {
        if (!this.passcodeProtected.isOnCooldown() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.m_5534_(typedChar, keyCode);
            this.f_96541_.f_91074_.m_5496_((SoundEvent)SoundEvents.f_12490_.get(), 0.15f, 1.0f);
        }
        return true;
    }

    private boolean isValidChar(char c) {
        for (char allowedChar : this.allowedChars) {
            if (c != allowedChar) continue;
            return true;
        }
        return false;
    }

    private void addNumberToString(int number) {
        this.keycodeTextbox.m_94164_("" + number);
    }

    private void removeLastCharacter() {
        if (!this.keycodeTextbox.m_94155_().isEmpty()) {
            this.keycodeTextbox.m_94180_(-1);
        }
    }

    private void toggleChildrenActive(boolean setActive) {
        this.m_6702_().forEach(listener -> {
            if (listener instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)listener;
                widget.f_93623_ = setActive;
            }
        });
        this.keycodeTextbox.m_93692_(setActive);
    }

    public void checkCode(String code) {
        IModuleInventory moduleInv;
        IPasscodeProtected iPasscodeProtected = this.passcodeProtected;
        if (iPasscodeProtected instanceof IModuleInventory && (moduleInv = (IModuleInventory)((Object)iPasscodeProtected)).isModuleEnabled(ModuleType.SMART)) {
            this.toggleChildrenActive(false);
        }
        this.keycodeTextbox.m_94144_("");
        IPasscodeProtected iPasscodeProtected2 = this.passcodeProtected;
        if (iPasscodeProtected2 instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iPasscodeProtected2;
            SecurityCraft.CHANNEL.sendToServer((Object)new CheckPasscode(be.m_58899_(), code));
        } else {
            iPasscodeProtected2 = this.passcodeProtected;
            if (iPasscodeProtected2 instanceof Entity) {
                Entity entity = (Entity)iPasscodeProtected2;
                SecurityCraft.CHANNEL.sendToServer((Object)new CheckPasscode(entity.m_19879_(), code));
            }
        }
    }

    public static class CensoringEditBox
    extends EditBox {
        private String renderedText = "";
        private boolean shouldCensor = true;

        public CensoringEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
            this.m_94151_(this::updateRenderedText);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            String originalValue = this.f_94093_;
            this.f_94093_ = this.renderedText;
            boolean success = super.m_6375_(mouseX, mouseY, button);
            this.f_94093_ = originalValue;
            return success;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            String originalValue = this.f_94093_;
            this.f_94093_ = this.renderedText;
            super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
            this.f_94093_ = originalValue;
        }

        public void m_94208_(int position) {
            String originalValue = this.f_94093_;
            this.updateRenderedText(originalValue);
            this.f_94093_ = this.renderedText;
            super.m_94208_(position);
            this.f_94093_ = originalValue;
        }

        public void setCensoring(boolean shouldCensor) {
            this.shouldCensor = shouldCensor;
            this.updateRenderedText(this.f_94093_);
        }

        private void updateRenderedText(String original) {
            if (this.shouldCensor) {
                Object x = "";
                for (int i = 1; i <= original.length(); ++i) {
                    x = (String)x + "*";
                }
                this.renderedText = x;
            } else {
                this.renderedText = original;
            }
        }
    }
}

