/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.client.handler;

import glitchcore.event.client.ItemTooltipEvent;
import glitchcore.event.client.RenderTooltipEvent;
import glitchcore.util.Environment;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import toughasnails.init.ModConfig;
import toughasnails.init.ModTags;
import toughasnails.thirst.ThirstOverlayRenderer;

public class TooltipHandler {
    public static void onTooltip(ItemTooltipEvent event) {
        if (!ModConfig.temperature.enableTemperature) {
            return;
        }
        if (!Environment.isClient()) {
            throw new IllegalStateException("ItemTooltipEvent unexpectedly called on the server");
        }
        if (Minecraft.m_91087_().m_91403_() == null) {
            return;
        }
        ItemStack stack = event.getStack();
        Block block = Block.m_49814_((Item)stack.m_41720_());
        BlockState state = block.m_49966_();
        RegistryAccess registryAccess = Minecraft.m_91087_().m_91403_().m_105152_();
        Optional trim = ArmorTrim.m_266285_((RegistryAccess)registryAccess, (ItemStack)stack);
        Optional trimMaterial = TrimMaterials.m_266539_((RegistryAccess)registryAccess, (ItemStack)stack);
        if (state.m_204336_(ModTags.Blocks.HEATING_BLOCKS) || stack.m_204117_(ModTags.Items.HEATING_ARMOR) || trim.isPresent() && ((ArmorTrim)trim.get()).m_266210_().m_203656_(ModTags.Trims.HEATING_TRIMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.heating")).m_130940_(ChatFormatting.GOLD));
        }
        if (state.m_204336_(ModTags.Blocks.COOLING_BLOCKS) || stack.m_204117_(ModTags.Items.COOLING_ARMOR) || trim.isPresent() && ((ArmorTrim)trim.get()).m_266210_().m_203656_(ModTags.Trims.COOLING_TRIMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\u2744 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.cooling")).m_130940_(ChatFormatting.AQUA));
        }
        if (stack.m_204117_(ModTags.Items.HEATING_HELD_ITEMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.heating_held")).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ModTags.Items.COOLING_HELD_ITEMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\u2744 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.cooling_held")).m_130940_(ChatFormatting.AQUA));
        }
        if (stack.m_204117_(ModTags.Items.HEATING_CONSUMED_ITEMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.heating_consumed")).m_130940_(ChatFormatting.GOLD));
        }
        if (stack.m_204117_(ModTags.Items.COOLING_CONSUMED_ITEMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\u2744 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.cooling_consumed")).m_130940_(ChatFormatting.AQUA));
        }
        if (trimMaterial.isPresent() && ((Holder.Reference)trimMaterial.get()).m_203656_(ModTags.Trims.HEATING_TRIMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\ud83d\udd25 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.heating_trim")).m_130940_(ChatFormatting.GOLD));
        }
        if (trimMaterial.isPresent() && ((Holder.Reference)trimMaterial.get()).m_203656_(ModTags.Trims.COOLING_TRIMS)) {
            event.getTooltip().add(Component.m_237113_((String)"\u2744 ").m_7220_((Component)Component.m_237115_((String)"desc.toughasnails.cooling_trim")).m_130940_(ChatFormatting.AQUA));
        }
    }

    public static void onRenderTooltip(RenderTooltipEvent event) {
        ItemStack stack = event.getStack();
        if (!ModConfig.thirst.enableThirst) {
            return;
        }
        if (stack.m_204117_(ModTags.Items.DRINKS)) {
            event.getComponents().add(new ThirstClientTooltipComponent(ModTags.Items.getThirstRestored(stack)));
        }
    }

    private static class ThirstClientTooltipComponent
    implements ClientTooltipComponent {
        private final int amount;

        private ThirstClientTooltipComponent(int amount) {
            this.amount = amount;
        }

        public int m_142103_() {
            return 9;
        }

        public int m_142069_(Font font) {
            return this.amount / 2 * 8;
        }

        public void m_183452_(Font font, int x, int y, GuiGraphics gui) {
            gui.m_280168_().m_85836_();
            for (int i = 0; i < Mth.m_14167_((float)((float)this.amount / 2.0f)); ++i) {
                int dropletHalf = i * 2 + 1;
                int startX = x + i * 8;
                int startY = y;
                if (this.amount > dropletHalf) {
                    gui.m_280163_(ThirstOverlayRenderer.OVERLAY, startX, startY, 0.0f, 41.0f, 8, 8, 256, 256);
                    continue;
                }
                if (this.amount != dropletHalf) continue;
                gui.m_280163_(ThirstOverlayRenderer.OVERLAY, startX, startY, 8.0f, 41.0f, 8, 8, 256, 256);
            }
            gui.m_280168_().m_85849_();
        }
    }
}

