/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import com.google.common.collect.ImmutableList;
import glitchcore.config.Config;
import glitchcore.util.Environment;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import toughasnails.temperature.BuiltInTemperatureModifier;

public class TemperatureConfig
extends Config {
    public boolean enableTemperature;
    public int temperatureChangeDelay;
    public int armorTemperatureChangeDelay;
    public int handheldTemperatureChangeDelay;
    public int playerTemperatureChangeDelay;
    public int internalTemperatureChangeDelay;
    public int extremityReboundTemperatureChangeDelay;
    public int extremityDamageDelay;
    public int climateClemencyDuration;
    public boolean climateClemencyRespawning;
    public int consumableEffectDuration;
    public int temperatureDropAltitude;
    public int temperatureRiseAltitude;
    public int environmentalModifierAltitude;
    public int nearHeatCoolProximity;
    public int nightHotTemperatureChange;
    public int nightTemperatureChange;
    public int onFireTemperatureChange;
    public int powderSnowTemperatureChange;
    public int wetTemperatureChange;
    public int snowTemperatureChange;
    public int wetTicks;
    public List<String> temperatureModifierOrder;
    private static final List<String> DEFAULT_TEMPERATURE_MODIFIER_ORDER = ImmutableList.of((Object)((Object)BuiltInTemperatureModifier.PLAYER_MODIFIERS), (Object)((Object)BuiltInTemperatureModifier.ITEM_MODIFIER), (Object)((Object)BuiltInTemperatureModifier.ARMOR_MODIFIER), (Object)((Object)BuiltInTemperatureModifier.INTERNAL_MODIFIER)).stream().map(e -> e.toString().toLowerCase()).toList();
    private static final Predicate<List<String>> TEMPERATURE_MODIFIER_VALIDATOR = list -> {
        Set allModifiers;
        Set configEntries = list.stream().map(String::toLowerCase).collect(Collectors.toSet());
        return configEntries.containsAll(allModifiers = Arrays.stream(BuiltInTemperatureModifier.values()).map(m -> m.toString().toLowerCase()).collect(Collectors.toSet())) && allModifiers.containsAll(configEntries);
    };

    public TemperatureConfig() {
        super(Environment.getConfigPath().resolve("toughasnails/temperature.toml"));
    }

    public void load() {
        this.enableTemperature = (Boolean)this.add("toggles.enable_temperature", true, "Enable or disable temperature.");
        this.temperatureChangeDelay = (Integer)this.addNumber("general.temperature_change_delay", 500, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes.");
        this.armorTemperatureChangeDelay = (Integer)this.addNumber("general.armor_temperature_change_delay", 50, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes when wearing armor.");
        this.handheldTemperatureChangeDelay = (Integer)this.addNumber("general.handheld_temperature_change_delay", 375, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes when holding an item.");
        this.playerTemperatureChangeDelay = (Integer)this.addNumber("general.player_temperature_change_delay", 125, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes when affected by a player-based temperature modifier.");
        this.internalTemperatureChangeDelay = (Integer)this.addNumber("general.internal_temperature_change_delay", 20, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes from consuming a heating or cooling item.");
        this.extremityReboundTemperatureChangeDelay = (Integer)this.addNumber("general.extremity_rebound_temperature_change_delay", 250, 0, Integer.MAX_VALUE, "Number of ticks to delay changing the player's temperature after their temperature changes when rebounding from an extreme temperature.");
        this.extremityDamageDelay = (Integer)this.addNumber("general.extremity_damage_delay", 500, 0, Integer.MAX_VALUE, "Number of ticks to delay taking damage when icy or hot.");
        this.climateClemencyDuration = (Integer)this.addNumber("general.climate_clemency_duration", 6000, 0, Integer.MAX_VALUE, "Number of ticks for the duration of Climate Clemency.");
        this.climateClemencyRespawning = (Boolean)this.add("general.climate_clemency_respawning", false, "Whether or not Climate Clemency should be granted when respawning.");
        this.consumableEffectDuration = (Integer)this.add("general.consumable_effect_duration", 1200, "Duration of heating or cooling effects given by consuming items.");
        this.temperatureModifierOrder = (List)this.add("general.temperature_modifier_order", DEFAULT_TEMPERATURE_MODIFIER_ORDER, "The order in which to apply built-in temperature modifiers", TEMPERATURE_MODIFIER_VALIDATOR);
        this.temperatureDropAltitude = (Integer)this.addNumber("altitude.temperature_drop_altitude", 160, -64, 1024, "Y level to drop the temperature at when above");
        this.temperatureRiseAltitude = (Integer)this.addNumber("altitude.temperature_rise_altitude", -32, -64, 1024, "Y level to rise the temperature at when below");
        this.environmentalModifierAltitude = (Integer)this.addNumber("altitude.environmental_modifier_altitude", 50, -64, 256, "Y level above which environmental modifiers are applied");
        this.nearHeatCoolProximity = (Integer)this.addNumber("blocks.near_heat_cool_proximity", 8, 1, 16, "The proximity which constitutes near a heat or cool source");
        this.onFireTemperatureChange = (Integer)this.addNumber("immersion.on_fire_temperature_change", 2, -4, 4, "Amount to change the temperature by when on fire.");
        this.powderSnowTemperatureChange = (Integer)this.addNumber("immersion.powdered_snow_temperature_change", -2, -4, 4, "Amount to change the temperature by when in powdered snow.");
        this.wetTemperatureChange = (Integer)this.addNumber("immersion.wet_temperature_change", -1, -4, 4, "Amount to change the temperature by when wet.");
        this.snowTemperatureChange = (Integer)this.addNumber("immersion.snow_temperature_change", -1, -4, 4, "Amount to change the temperature by when snowing.");
        this.wetTicks = (Integer)this.addNumber("immersion.wet_ticks", 40, 0, Integer.MAX_VALUE, "Number of ticks a player stays wet for after touching water, rain or snow.");
        this.nightTemperatureChange = (Integer)this.addNumber("time.night_temperature_change", -1, -4, 4, "Amount to change the temperature at night when the original temperature is not hot.");
        this.nightHotTemperatureChange = (Integer)this.addNumber("time.night_hot_temperature_change", -2, -4, 4, "Amount to change the temperature at night when the original temperature is hot.");
    }
}

