/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.crafting;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import toughasnails.api.block.TANBlocks;
import toughasnails.api.crafting.TANRecipeSerializers;
import toughasnails.api.crafting.TANRecipeTypes;
import toughasnails.util.serialization.ItemStackDeserializer;

public class WaterPurifierRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final ItemStack input;
    protected final ItemStack result;
    protected final int purifyTime;

    public WaterPurifierRecipe(ResourceLocation resourceLocation, ItemStack input, ItemStack itemStack, int i) {
        this.id = resourceLocation;
        this.input = input;
        this.result = itemStack;
        this.purifyTime = i;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (this.input == null) {
            return false;
        }
        ItemStack containerInput = inv.m_8020_(0);
        return ItemStack.m_150942_((ItemStack)this.input, (ItemStack)containerInput) && this.input.m_41773_() == containerInput.m_41773_();
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int i, int j) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.input}));
        return nonNullList;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeType<?> m_6671_() {
        return TANRecipeTypes.WATER_PURIFYING;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)TANBlocks.WATER_PURIFIER);
    }

    public RecipeSerializer<?> m_7707_() {
        return TANRecipeSerializers.WATER_PURIFYING;
    }

    public boolean m_5598_() {
        return true;
    }

    public int getPurifyTime() {
        return this.purifyTime;
    }

    public static class Serializer
    implements RecipeSerializer<WaterPurifierRecipe> {
        public WaterPurifierRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ItemStack input = ItemStackDeserializer.deserialize(jsonObject.getAsJsonObject("input"));
            ItemStack result = ItemStackDeserializer.deserialize(jsonObject.getAsJsonObject("result"));
            int purifyTime = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"purifytime");
            return new WaterPurifierRecipe(resourceLocation, input, result, purifyTime);
        }

        public WaterPurifierRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            ItemStack input = buffer.m_130267_();
            ItemStack result = buffer.m_130267_();
            int purifyTime = buffer.readInt();
            return new WaterPurifierRecipe(resourceLocation, input, result, purifyTime);
        }

        public void toNetwork(FriendlyByteBuf buffer, WaterPurifierRecipe recipe) {
            buffer.m_130055_(recipe.input);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.purifyTime);
        }
    }
}

