/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.forge.datagen.recipes;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;
import toughasnails.crafting.WaterPurifierRecipe;
import toughasnails.util.serialization.ItemStackDeserializer;

public class WaterPurifierRecipeBuilder {
    private final ItemStack input;
    private final ItemStack result;
    private final int purifyTime;

    private WaterPurifierRecipeBuilder(ItemStack input, ItemStack result, int purifyTime) {
        this.input = input;
        this.result = result;
        this.purifyTime = purifyTime;
    }

    public static WaterPurifierRecipeBuilder waterPurifier(ItemStack input, ItemStack result, int purifyTime) {
        return new WaterPurifierRecipeBuilder(input, result, purifyTime);
    }

    public void save(Consumer<FinishedRecipe> output, ResourceLocation location, ItemStack input, ItemStack result, int purifyTime) {
        output.accept(new Result(location, input, result, purifyTime));
    }

    public static class Result
    implements FinishedRecipe {
        public static final RecipeSerializer<?> TYPE = RecipeSerializer.m_44098_((String)"toughasnails:water_purifying", (RecipeSerializer)new WaterPurifierRecipe.Serializer());
        private final ResourceLocation id;
        private final ItemStack input;
        private final ItemStack result;
        private final int purifyTime;

        public Result(ResourceLocation resourceLocation, ItemStack input, ItemStack result, int purifyTime) {
            this.id = resourceLocation;
            this.input = input;
            this.result = result;
            this.purifyTime = purifyTime;
        }

        public void m_7917_(JsonObject jsonObject) {
            jsonObject.addProperty("purifytime", (Number)this.purifyTime);
            jsonObject.add("input", ItemStackDeserializer.serialize(this.input));
            jsonObject.add("result", ItemStackDeserializer.serialize(this.result));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return TYPE;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

