/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureLevel;
import toughasnails.init.ModConfig;

public class TemperatureData
implements ITemperature {
    public static final TemperatureLevel DEFAULT_LEVEL = TemperatureLevel.NEUTRAL;
    private TemperatureLevel level = DEFAULT_LEVEL;
    private TemperatureLevel targetLevel = DEFAULT_LEVEL;
    private int positionalChangeDelayTicks;
    private int ticksHyperthermic;
    private int ticksDry;
    private int extremityDelayTicks;
    private Set<BlockPos> nearbyThermoregulators = new HashSet<BlockPos>();
    private TemperatureLevel lastTemperature = DEFAULT_LEVEL;
    private int lastHyperthermiaTicks;
    private Set<BlockPos> lastNearbyThermoregulators = new HashSet<BlockPos>();

    public void addAdditionalSaveData(CompoundTag nbt) {
        if (ModConfig.temperature.enableTemperature) {
            nbt.m_128405_("temperatureLevel", this.getLevel().ordinal());
            nbt.m_128405_("targetTemperatureLevel", this.getTargetLevel().ordinal());
            nbt.m_128405_("changeDelayTicks", this.getChangeDelayTicks());
            nbt.m_128405_("hyperthermiaTicks", this.getHyperthermiaTicks());
            nbt.m_128405_("extremityDelayTicks", this.getExtremityDelayTicks());
            nbt.m_128405_("dryTicks", this.getDryTicks());
        } else {
            nbt.m_128405_("temperatureLevel", DEFAULT_LEVEL.ordinal());
            nbt.m_128405_("targetTemperatureLevel", DEFAULT_LEVEL.ordinal());
            nbt.m_128405_("changeDelayTicks", 0);
            nbt.m_128405_("hyperthermiaTicks", 0);
            nbt.m_128405_("extremityDelayTicks", 0);
            nbt.m_128405_("dryTicks", 0);
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.m_128425_("temperatureLevel", 99)) {
            if (ModConfig.temperature.enableTemperature) {
                this.setLevel(TemperatureLevel.values()[nbt.m_128451_("temperatureLevel")]);
                this.setTargetLevel(TemperatureLevel.values()[nbt.m_128451_("targetTemperatureLevel")]);
                this.setChangeDelayTicks(nbt.m_128451_("changeDelayTicks"));
                this.setHyperthermiaTicks(nbt.m_128451_("hyperthermiaTicks"));
                this.setExtremityDelayTicks(nbt.m_128451_("extremityDelayTicks"));
            } else {
                this.setLevel(DEFAULT_LEVEL);
                this.setTargetLevel(DEFAULT_LEVEL);
                this.setChangeDelayTicks(0);
                this.setHyperthermiaTicks(0);
                this.setExtremityDelayTicks(0);
                this.setDryTicks(0);
            }
        }
    }

    @Override
    public TemperatureLevel getLevel() {
        return this.level;
    }

    @Override
    public int getHyperthermiaTicks() {
        return this.ticksHyperthermic;
    }

    @Override
    public int getExtremityDelayTicks() {
        return this.extremityDelayTicks;
    }

    @Override
    public int getDryTicks() {
        return this.ticksDry;
    }

    @Override
    public TemperatureLevel getLastLevel() {
        return this.lastTemperature;
    }

    @Override
    public TemperatureLevel getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public int getChangeDelayTicks() {
        return this.positionalChangeDelayTicks;
    }

    @Override
    public int getLastHyperthermiaTicks() {
        return this.lastHyperthermiaTicks;
    }

    @Override
    public Set<BlockPos> getLastNearbyThermoregulators() {
        return this.lastNearbyThermoregulators;
    }

    @Override
    public Set<BlockPos> getNearbyThermoregulators() {
        return this.nearbyThermoregulators;
    }

    @Override
    public void setLevel(TemperatureLevel level) {
        this.level = level;
    }

    @Override
    public void setHyperthermiaTicks(int ticks) {
        this.ticksHyperthermic = ticks;
    }

    @Override
    public void setExtremityDelayTicks(int ticks) {
        this.extremityDelayTicks = ticks;
    }

    @Override
    public void setDryTicks(int ticks) {
        this.ticksDry = ticks;
    }

    @Override
    public void setLastLevel(TemperatureLevel level) {
        this.lastTemperature = level;
    }

    @Override
    public void setTargetLevel(TemperatureLevel level) {
        this.targetLevel = level;
    }

    @Override
    public void setChangeDelayTicks(int ticks) {
        this.positionalChangeDelayTicks = ticks;
    }

    @Override
    public void setLastHyperthermiaTicks(int ticks) {
        this.lastHyperthermiaTicks = ticks;
    }

    @Override
    public void setLastNearbyThermoregulators(Set<BlockPos> values) {
        this.lastNearbyThermoregulators = values;
    }

    @Override
    public void setNearbyThermoregulators(Set<BlockPos> values) {
        this.nearbyThermoregulators = values;
    }
}

