/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import glitchcore.event.TickEvent;
import glitchcore.event.client.RenderGuiEvent;
import glitchcore.util.GuiUtils;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;

public class ThirstOverlayRenderer {
    private static final Random RANDOM = new Random();
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/icons.png");
    private static int updateCounter;

    public static void onClientTick(TickEvent.Client event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (event.getPhase() == TickEvent.Phase.END && !minecraft.m_91104_()) {
            ++updateCounter;
        }
    }

    public static void onBeginRenderAir(RenderGuiEvent.Pre event) {
        boolean isMounted;
        if (event.getType() != RenderGuiEvent.Type.AIR || !ModConfig.thirst.enableThirst) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Entity vehicle = minecraft.f_91074_.m_20202_();
        boolean bl = isMounted = vehicle != null && vehicle.m_20152_();
        if (!isMounted && !minecraft.f_91066_.f_92062_ && GuiUtils.shouldDrawSurvivalElements()) {
            GuiUtils.setupOverlayRenderState((boolean)true, (boolean)false);
            LocalPlayer player = minecraft.f_91074_;
            IThirst thirst = ThirstHelper.getThirst((Player)player);
            RANDOM.setSeed((long)updateCounter * 312871L);
            int rowTop = event.getRowTop();
            ThirstOverlayRenderer.drawThirst(event.getGuiGraphics(), event.getScreenWidth(), rowTop, thirst.getThirst(), thirst.getHydration());
            event.setRowTop(rowTop - 10);
        }
    }

    public static void drawThirst(GuiGraphics guiGraphics, int screenWidth, int rowTop, int thirstLevel, float thirstHydrationLevel) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        int left = screenWidth / 2 + 91 + ModConfig.client.thirstLeftOffset;
        int top = rowTop + ModConfig.client.thirstTopOffset;
        for (int i = 0; i < 10; ++i) {
            int dropletHalf = i * 2 + 1;
            int iconIndex = 0;
            int startX = left - i * 8 - 9;
            int startY = top;
            int backgroundU = 0;
            if (player.m_21023_(TANEffects.THIRST)) {
                iconIndex += 4;
                backgroundU += 117;
            }
            if (thirstHydrationLevel <= 0.0f && updateCounter % (thirstLevel * 3 + 1) == 0) {
                startY = top + (RANDOM.nextInt(3) - 1);
            }
            guiGraphics.m_280218_(OVERLAY, startX, startY, backgroundU, 32, 9, 9);
            if (thirstLevel > dropletHalf) {
                guiGraphics.m_280218_(OVERLAY, startX, startY, (iconIndex + 4) * 9, 32, 9, 9);
                continue;
            }
            if (thirstLevel != dropletHalf) continue;
            guiGraphics.m_280218_(OVERLAY, startX, startY, (iconIndex + 5) * 9, 32, 9, 9);
        }
    }
}

