/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.util.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ItemStackDeserializer {
    private static final String NAME = "id";
    private static final String STACK_SIZE = "Count";
    private static final String TAG_COMPOUND = "tag";

    public static ItemStack deserialize(JsonObject jsonObject) {
        String name = null;
        int stackSize = 1;
        CompoundTag tagCompound = null;
        if (jsonObject.has(NAME)) {
            name = GsonHelper.m_13906_((JsonObject)jsonObject, (String)NAME);
        }
        if (jsonObject.has(STACK_SIZE)) {
            stackSize = GsonHelper.m_13927_((JsonObject)jsonObject, (String)STACK_SIZE);
        }
        if (jsonObject.has(TAG_COMPOUND)) {
            try {
                JsonObject tagJsonObject = GsonHelper.m_13930_((JsonObject)jsonObject, (String)TAG_COMPOUND);
                tagCompound = TagParser.m_129359_((String)tagJsonObject.toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        if (name != null) {
            ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(name)), stackSize);
            if (tagCompound != null) {
                itemStack.m_41751_(tagCompound);
            }
            return itemStack;
        }
        return null;
    }

    public static JsonElement serialize(ItemStack itemStack) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty(NAME, BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_()).m_135815_());
        jsonObject.addProperty(STACK_SIZE, (Number)itemStack.m_41613_());
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            jsonObject.addProperty(TAG_COMPOUND, tag.toString());
        }
        return jsonObject;
    }
}

