/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.IExtraGuiHandling;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigHandler;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShiftScrollWheel;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static float currentScreenRoll = 0.0f;
    private static final int Z_LEVEL = 233;

    @SubscribeEvent
    public static void screenTilt(ViewportEvent.ComputeCameraAngles event) {
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET) && !player.m_20096_()) {
                float targetRoll;
                float div = 50.0f;
                JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(player);
                if (jbState.isActive() && !jbState.isBuilderMode()) {
                    float roll = player.f_20885_ - player.f_20886_;
                    if ((double)Math.abs(roll) < 1.0E-4) {
                        targetRoll = 0.0f;
                    } else {
                        targetRoll = Math.signum(roll) * (float)((Integer)ConfigHelper.client().armor.maxJetBootsFlightRoll.get()).intValue();
                        div = Math.abs(100.0f / roll);
                    }
                } else {
                    targetRoll = 0.0f;
                }
                currentScreenRoll += (targetRoll - currentScreenRoll) / div;
                event.setRoll(currentScreenRoll);
            } else {
                currentScreenRoll = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void playerPreRotateEvent(RenderPlayerEvent.Pre event) {
        JetBootsStateTracker.JetBootsState state;
        Player player = event.getEntity();
        if (!player.m_21255_() && (state = JetBootsStateTracker.getClientTracker().getJetBootsState(player)) != null && state.shouldRotatePlayer()) {
            player.f_267362_.m_267771_(0.0f);
        }
    }

    @SubscribeEvent
    public static void adjustFOVEvent(ComputeFovModifierEvent event) {
        float modifier = 1.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = event.getPlayer().m_6844_(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof IFOVModifierItem)) continue;
            IFOVModifierItem fovModifier = (IFOVModifierItem)item;
            modifier *= fovModifier.getFOVModifier(stack, event.getPlayer(), slot);
        }
        event.setNewFovModifier(event.getNewFovModifier() * modifier);
    }

    @SubscribeEvent
    public static void fogDensityEvent(ViewportEvent.RenderFog event) {
        if (event.getCamera().m_167685_() == FogType.WATER && event.getCamera().m_90592_() instanceof Player) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer();
            if (handler.upgradeUsable(CommonUpgradeHandlers.scubaHandler, true)) {
                event.setNearPlaneDistance(20.0f);
                event.setNearPlaneDistance(50.0f);
                event.setFogShape(FogShape.SPHERE);
                event.setCanceled(true);
            }
        } else if (ClientEventHandler.isPlayerHeadInOil()) {
            event.setNearPlaneDistance(0.25f);
            event.setFarPlaneDistance(2.0f);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void fogColorEvent(ViewportEvent.ComputeFogColor event) {
        if (ClientEventHandler.isPlayerHeadInOil()) {
            event.setRed(0.1f);
            event.setGreen(0.1f);
            event.setBlue(0.1f);
        }
    }

    private static boolean isPlayerHeadInOil() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        return player != null && !player.m_5833_() && player.m_9236_().m_8055_(BlockPos.m_274446_((Position)player.m_146892_())).m_60734_() == ModBlocks.OIL.get();
    }

    @SubscribeEvent
    public static void guiContainerForeground(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof IExtraGuiHandling) {
            IExtraGuiHandling e = (IExtraGuiHandling)abstractContainerScreen;
            e.drawExtras(event);
        }
        AbstractContainerScreen container = event.getContainerScreen();
        PoseStack poseStack = event.getGuiGraphics().m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 300.0f);
        for (Slot s : container.m_6262_().f_38839_) {
            int yOff;
            ICustomDurabilityBar custom;
            Item item = s.m_7993_().m_41720_();
            if (!(item instanceof ICustomDurabilityBar) || !(custom = (ICustomDurabilityBar)item).shouldShowCustomDurabilityBar(s.m_7993_())) continue;
            int x = s.f_40220_;
            int y = s.f_40221_;
            int width = Math.round(custom.getCustomDurability(s.m_7993_()) * 13.0f);
            int col = custom.getCustomDurabilityColour(s.m_7993_());
            int n = yOff = custom.isShowingOtherBar(s.m_7993_()) ? 0 : 1;
            if (yOff == 1) {
                event.getGuiGraphics().m_280509_(x + 2, y + 14, x + 2 + width, y + 15, -14145496);
            }
            event.getGuiGraphics().m_280509_(x + 2, y + 12 + yOff, x + 15, y + 13 + yOff, -16777216);
            event.getGuiGraphics().m_280509_(x + 2, y + 12 + yOff, x + 2 + width, y + 13 + yOff, 0xFF000000 | col);
        }
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public static void onGuiDrawPost(ScreenEvent.Render.Post event) {
        List<IDrawAfterRender> toDraw;
        if ((event.getScreen() instanceof AbstractPneumaticCraftContainerScreen || event.getScreen() instanceof AbstractPneumaticCraftScreen) && !(toDraw = event.getScreen().m_6702_().stream().filter(l -> l instanceof IDrawAfterRender).map(l -> (IDrawAfterRender)l).toList()).isEmpty()) {
            PoseStack poseStack = event.getGuiGraphics().m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 500.0f);
            toDraw.forEach(d -> d.renderAfterEverythingElse(event.getGuiGraphics(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onShiftScroll(InputEvent.MouseScrollingEvent event) {
        if (ClientUtils.getClientPlayer().m_6047_() && !ClientEventHandler.tryHand(event, InteractionHand.MAIN_HAND)) {
            ClientEventHandler.tryHand(event, InteractionHand.OFF_HAND);
        }
    }

    private static boolean tryHand(InputEvent.MouseScrollingEvent event, InteractionHand hand) {
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof IShiftScrollable) {
            IShiftScrollable s = (IShiftScrollable)item;
            NetworkHandler.sendToServer(new PacketShiftScrollWheel(event.getScrollDelta() > 0.0, InteractionHand.MAIN_HAND));
            s.onShiftScrolled(ClientUtils.getClientPlayer(), event.getScrollDelta() > 0.0, InteractionHand.MAIN_HAND);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onClientConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        AuxConfigHandler.postInit(IAuxConfig.Sidedness.CLIENT);
        ArmorMainScreen.initHelmetCoreComponents();
    }
}

