/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.AirCompressorBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AirCompressorMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;

public class AirCompressorScreen
extends AbstractPneumaticCraftContainerScreen<AirCompressorMenu, AirCompressorBlockEntity> {
    public AirCompressorScreen(AirCompressorMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_AIR_COMPRESSOR;
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        int yOff = ((AirCompressorBlockEntity)this.te).getBurnTimeRemainingScaled(12);
        if (((AirCompressorBlockEntity)this.te).burnTime >= ((AirCompressorBlockEntity)this.te).curFuelUsage) {
            graphics.m_280218_(this.getGuiTexture(), this.f_97735_ + this.getFuelSlotXOffset(), this.f_97736_ + 38 + 12 - yOff, 176, 12 - yOff, 14, yOff + 2);
        }
    }

    protected int getFuelSlotXOffset() {
        return 80;
    }

    @Override
    protected void addPressureStatInfo(List<Component> pressureStatText) {
        super.addPressureStatInfo(pressureStatText);
        pressureStatText.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.maxProduction", PneumaticCraftUtils.roundNumberTo(((AirCompressorBlockEntity)this.te).airPerTick, 2)).m_130940_(ChatFormatting.BLACK));
    }

    @Override
    protected void addProblems(List<Component> textList) {
        super.addProblems(textList);
        if (((AirCompressorBlockEntity)this.te).burnTime <= ((AirCompressorBlockEntity)this.te).curFuelUsage && !FurnaceBlockEntity.m_58399_((ItemStack)((AirCompressorBlockEntity)this.te).getPrimaryInventory().getStackInSlot(0))) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.airCompressor.noFuel", new Object[0]));
        }
        if (((AirCompressorBlockEntity)this.te).hasNoConnectedAirHandlers()) {
            textList.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.airLeak", new Object[0]));
        }
    }

    @Override
    protected String upgradeCategory() {
        return "air_compressor";
    }
}

