/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.IFluidItemRenderInfoProvider;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractFluidTankBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RenderFluidTank
extends AbstractFluidTER<AbstractFluidTankBlockEntity> {
    private static final AABB BOUNDS_NONE = new AABB(0.125625, 0.063125, 0.125625, 0.874375, 0.936875, 0.874375);
    private static final AABB BOUNDS_UP = new AABB(0.125625, 0.063125, 0.125625, 0.874375, 1.0, 0.874375);
    private static final AABB BOUNDS_DOWN = new AABB(0.125625, 0.0, 0.125625, 0.874375, 0.936875, 0.874375);
    private static final AABB BOUNDS_BOTH = new AABB(0.125625, 0.0, 0.125625, 0.874375, 1.0, 0.874375);

    public RenderFluidTank(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    Collection<TankRenderInfo> getTanksToRender(AbstractFluidTankBlockEntity te) {
        boolean up = (Boolean)te.m_58900_().m_61143_((Property)AbstractPneumaticCraftBlock.UP);
        boolean down = (Boolean)te.m_58900_().m_61143_((Property)AbstractPneumaticCraftBlock.DOWN);
        AABB bounds = up && down ? BOUNDS_BOTH : (up ? BOUNDS_UP : (down ? BOUNDS_DOWN : BOUNDS_NONE));
        return Collections.singletonList(new FluidTankRenderInfo((IFluidTank)te.getTank(), up, down, bounds));
    }

    private static class FluidTankRenderInfo
    extends TankRenderInfo {
        private final boolean up;
        private final boolean down;

        FluidTankRenderInfo(IFluidTank tank, boolean up, boolean down, AABB bounds) {
            super(tank, bounds, new Direction[0]);
            this.up = up;
            this.down = down;
        }

        @Override
        public boolean shouldRender(Direction face) {
            return switch (face) {
                case Direction.UP -> {
                    if (this.up || this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && !this.getTank().getFluid().getFluid().getFluidType().isLighterThanAir()) {
                        yield true;
                    }
                    yield false;
                }
                case Direction.DOWN -> {
                    if (this.down || this.getTank().getFluid().getAmount() < this.getTank().getCapacity() && this.getTank().getFluid().getFluid().getFluidType().isLighterThanAir()) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
        }
    }

    public static class ItemRenderInfoProvider
    implements IFluidItemRenderInfoProvider {
        @Override
        public List<TankRenderInfo> getTanksToRender(ItemStack stack) {
            IFluidHandler h = (IFluidHandler)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(RuntimeException::new);
            return Collections.singletonList(new TankRenderInfo(h.getFluidInTank(0), h.getTankCapacity(0), BOUNDS_NONE, new Direction[0]));
        }
    }
}

