/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.overlays;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.client.gui.widget.WidgetKeybindCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.render.ProgressBarRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class PneumaticArmorHUDOverlay
implements IGuiOverlay {
    private static final int PROGRESS_BAR_HEIGHT = 17;
    private final boolean[] gaveCriticalWarning = new boolean[4];
    private final boolean[] gaveLowPressureWarning = new boolean[4];

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        ItemStack armorStack;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91066_.f_92062_ || mc.f_91080_ != null || !PneumaticArmorItem.isPlayerWearingAnyPneumaticArmor((Player)player)) {
            return;
        }
        Window mw = Minecraft.m_91087_().m_91268_();
        graphics.m_280168_().m_85836_();
        CommonArmorHandler comHudHandler = CommonArmorHandler.getHandlerForPlayer((Player)player);
        boolean anyArmorInInit = false;
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.m_6844_(slot);
            if (!(armorStack.m_41720_() instanceof PneumaticArmorItem) || !(comHudHandler.getArmorPressure(slot) >= 1.0E-4f) || comHudHandler.isArmorReady(slot)) continue;
            anyArmorInInit = true;
            break;
        }
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            armorStack = player.m_6844_(slot);
            if (!(armorStack.m_41720_() instanceof PneumaticArmorItem) || !(comHudHandler.getArmorPressure(slot) >= 1.0E-4f)) continue;
            if (anyArmorInInit) {
                this.renderInitProgressBarForSlot(graphics, partialTicks, mw, comHudHandler, slot, armorStack);
            }
            if (!comHudHandler.isArmorReady(slot)) continue;
            this.renderHUDForSlot(graphics, partialTicks, (Player)player, comHudHandler, slot);
        }
        HUDHandler.getInstance().renderMessages(graphics, partialTicks);
        graphics.m_280168_().m_85849_();
        if (comHudHandler.isArmorEnabled() && anyArmorInInit) {
            for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
                if (!PneumaticArmorItem.isPneumaticArmorPiece((Player)player, slot) || !(comHudHandler.getArmorPressure(slot) > 0.0f)) continue;
                String text = Math.min(100, comHudHandler.getTicksSinceEquipped(slot) * 100 / comHudHandler.getStartupTime(slot)) + "%";
                graphics.drawString(mc.f_91062_, text, (float)mw.m_85445_() * 0.75f - 8.0f, (float)(14 + 17 * (3 - slot.m_20749_())), 0xFFFF40, true);
            }
        }
    }

    private void renderInitProgressBarForSlot(GuiGraphics graphics, float partialTicks, Window mw, CommonArmorHandler comHudHandler, EquipmentSlot slot, ItemStack armorStack) {
        if (comHudHandler.isArmorEnabled()) {
            int xLeft = mw.m_85445_() / 2;
            int yOffset = 10 + (3 - slot.m_20749_()) * 17;
            float progress = (float)comHudHandler.getTicksSinceEquipped(slot) * 100.0f / (float)comHudHandler.getStartupTime(slot);
            progress = Math.min(100.0f, progress + partialTicks);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            ProgressBarRenderer.render2d(graphics, (float)mw.m_85445_() / 2.0f, yOffset, mw.m_85445_() - 10, yOffset + 17 - 1, -90.0f, progress, -1426079744, -1442775296);
            RenderSystem.disableBlend();
            graphics.m_280480_(armorStack, xLeft + 2, yOffset);
        }
    }

    private void renderHUDForSlot(GuiGraphics matrixStack, float partialTicks, Player player, CommonArmorHandler comHudHandler, EquipmentSlot slot) {
        float pressure = comHudHandler.getArmorPressure(slot);
        this.handlePressureWarnings(player, slot, pressure);
        if (WidgetKeybindCheckBox.getCoreComponents().checked || Minecraft.m_91087_().f_91080_ == null) {
            List<IArmorUpgradeClientHandler<?>> renderHandlers = ClientArmorRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < renderHandlers.size(); ++i) {
                StatPanelLayout layout;
                IArmorUpgradeClientHandler<?> clientHandler = renderHandlers.get(i);
                if (!comHudHandler.isUpgradeInserted(slot, i) || !comHudHandler.isUpgradeEnabled(slot, i) && clientHandler.isToggleable()) continue;
                IGuiAnimatedStat stat = clientHandler.getAnimatedStat();
                if (stat != null && !(layout = ArmorHUDLayout.INSTANCE.getLayoutFor(clientHandler.getID(), clientHandler.getDefaultStatLayout())).hidden()) {
                    stat.renderStat(matrixStack, -1, -1, partialTicks);
                }
                clientHandler.render2D(matrixStack, partialTicks, pressure > 0.0f);
            }
        }
    }

    private void handlePressureWarnings(Player player, EquipmentSlot slot, float pressure) {
        if (pressure <= 0.1f && !this.gaveCriticalWarning[slot.m_20749_()]) {
            HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.outOfAir", player.m_6844_(slot).m_41786_()), 100, 0x70FF0000));
            this.gaveCriticalWarning[slot.m_20749_()] = true;
            player.m_5496_((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 2.0f);
        } else if (pressure > 0.1f && pressure <= 0.5f && !this.gaveLowPressureWarning[slot.m_20749_()]) {
            HUDHandler.getInstance().addMessage(new ArmorMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.message.almostOutOfAir", player.m_6844_(slot).m_41786_()), 60, 1895792640));
            this.gaveLowPressureWarning[slot.m_20749_()] = true;
        }
        if (pressure > 0.6f) {
            this.gaveLowPressureWarning[slot.m_20749_()] = false;
        }
        if (pressure > 0.2f) {
            this.gaveCriticalWarning[slot.m_20749_()] = false;
        }
    }
}

