/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public abstract class HarvestHandlerAbstractCrop
extends HarvestHandler {
    private final Predicate<BlockState> blockChecker;

    public HarvestHandlerAbstractCrop(Predicate<BlockState> blockChecker) {
        this.blockChecker = blockChecker;
    }

    @Override
    public boolean canHarvest(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        return this.blockChecker.test(state) && this.isMaxAge(state);
    }

    @Override
    public boolean harvestAndReplant(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        this.harvest(world, chunkCache, pos, state, drone);
        List seedItems = world.m_6443_(ItemEntity.class, new AABB(pos), entityItem -> this.isSeed(world, pos, state, entityItem.m_32055_()));
        if (!seedItems.isEmpty()) {
            ((ItemEntity)seedItems.get(0)).m_32055_().m_41774_(1);
            world.m_46597_(pos, this.withMinAge(state));
            return true;
        }
        return false;
    }

    protected abstract boolean isSeed(Level var1, BlockPos var2, BlockState var3, ItemStack var4);

    protected abstract boolean isMaxAge(BlockState var1);

    protected abstract BlockState withMinAge(BlockState var1);
}

