/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CamoApplicatorItem
extends PressurizableItem {
    public CamoApplicatorItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public Component m_7626_(ItemStack stack) {
        BlockState camoState = CamoApplicatorItem.getCamoState(stack, null);
        Component disp = super.m_7626_(stack);
        if (camoState != null) {
            return disp.m_6881_().m_130946_(": ").m_7220_(CamoApplicatorItem.getCamoStateDisplayName(camoState)).m_130940_(ChatFormatting.YELLOW);
        }
        return disp;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_6144_()) {
            if (!worldIn.f_46443_) {
                CamoApplicatorItem.setCamoState(playerIn.m_21120_(handIn), null);
            } else if (CamoApplicatorItem.getCamoState(playerIn.m_21120_(handIn), playerIn.m_9236_()) != null) {
                playerIn.m_5496_((SoundEvent)ModSounds.CHIRP.get(), 1.0f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)playerIn.m_21120_(handIn));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        if (player != null && !level.f_46443_) {
            if (player.m_6047_()) {
                CamoApplicatorItem.setCamoState(stack, null);
                level.m_5594_(null, ctx.m_8083_(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                BlockEntity te = level.m_7702_(pos);
                BlockState state = level.m_8055_(pos);
                if (!(te instanceof CamouflageableBlockEntity)) {
                    CamoApplicatorItem.setCamoState(stack, state);
                    level.m_5594_(null, ctx.m_8083_(), (SoundEvent)ModSounds.CHIRP.get(), SoundSource.PLAYERS, 1.0f, 2.0f);
                } else {
                    BlockState particleState;
                    ItemStack camoStack;
                    CamouflageableBlockEntity camoTE = (CamouflageableBlockEntity)te;
                    IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElseThrow(RuntimeException::new);
                    if (!player.m_7500_() && airHandler.getPressure() < 0.1f) {
                        return InteractionResult.FAIL;
                    }
                    BlockState newCamo = CamoApplicatorItem.getCamoState(stack, level);
                    BlockState existingCamo = camoTE.getCamouflage();
                    if (existingCamo == newCamo) {
                        level.m_5594_(null, ctx.m_8083_(), SoundEvents.f_11762_, SoundSource.PLAYERS, 1.0f, 2.0f);
                        return InteractionResult.SUCCESS;
                    }
                    if (newCamo != null && !player.m_7500_()) {
                        camoStack = CamouflageableBlockEntity.getStackForState(newCamo);
                        if (!PneumaticCraftUtils.consumeInventoryItem(player.m_150109_(), camoStack)) {
                            player.m_5661_((Component)Component.m_237115_((String)"pneumaticcraft.message.camo.notEnoughBlocks").m_7220_(camoStack.m_41786_()).m_130940_(ChatFormatting.RED), true);
                            NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.PLAYERS, pos, 1.0f, 2.0f, true), level, pos);
                            return InteractionResult.FAIL;
                        }
                    }
                    if (existingCamo != null && !player.m_7500_()) {
                        camoStack = CamouflageableBlockEntity.getStackForState(existingCamo);
                        ItemEntity entity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, camoStack);
                        level.m_7967_((Entity)entity);
                        entity.m_6123_(player);
                    }
                    if (!player.m_7500_()) {
                        airHandler.addAir(-50);
                    }
                    camoTE.setCamouflage(newCamo);
                    BlockState blockState = particleState = newCamo == null ? existingCamo : newCamo;
                    if (particleState != null) {
                        player.m_20193_().m_46796_(2001, pos, Block.m_49956_((BlockState)particleState));
                    }
                    NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.PLAYERS, pos, 1.0f, 1.0f, true), level, pos);
                }
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    private static void setCamoState(ItemStack stack, BlockState state) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tag = new CompoundTag();
        }
        if (state == null) {
            tag.m_128473_("CamoState");
        } else {
            tag.m_128365_("CamoState", (Tag)NbtUtils.m_129202_((BlockState)state));
        }
        stack.m_41751_(tag);
    }

    private static BlockState getCamoState(ItemStack stack, Level level) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("CamoState")) {
            return NbtUtils.m_247651_((HolderGetter)(level == null ? BuiltInRegistries.f_256975_.m_255303_() : level.m_246945_(Registries.f_256747_)), (CompoundTag)tag.m_128469_("CamoState"));
        }
        return null;
    }

    public static Component getCamoStateDisplayName(BlockState state) {
        if (state != null) {
            return new ItemStack((ItemLike)state.m_60734_().m_5456_()).m_41786_();
        }
        return Component.m_237113_((String)"<?>");
    }
}

