/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.logistics;

import java.util.List;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class LogisticsConfiguratorItem
extends PressurizableItem {
    public LogisticsConfiguratorItem() {
        super(ModItems.toolProps(), 30000, 3000);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Player player = ctx.m_43723_();
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && ((Boolean)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).map(h -> (double)h.getPressure() > 0.1).orElseThrow(RuntimeException::new)).booleanValue()) {
            Stream<ISemiBlock> semiBlocks = SemiblockTracker.getInstance().getAllSemiblocks(world, pos, side);
            boolean didWork = false;
            if (player.m_6144_()) {
                List<ISemiBlock> l = semiBlocks.filter(s -> !(s instanceof IDirectionalSemiblock) || ((IDirectionalSemiblock)((Object)s)).getSide() == side).toList();
                if (!l.isEmpty()) {
                    l.forEach(s -> s.killedByEntity((Entity)player));
                    didWork = true;
                }
            } else if (semiBlocks.anyMatch(s -> s.onRightClickWithConfigurator(player, side))) {
                didWork = true;
            }
            if (didWork) {
                if (!player.m_7500_()) {
                    stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> h.addAir(-50));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

