/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.ProgrammableControllerBlockEntity;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class PacketDroneDebugBase {
    final int entityId;
    final BlockPos pos;

    public PacketDroneDebugBase(IDroneBase drone) {
        if (drone instanceof DroneEntity) {
            this.entityId = ((DroneEntity)drone).m_19879_();
            this.pos = null;
        } else if (drone instanceof ProgrammableControllerBlockEntity) {
            this.pos = ((ProgrammableControllerBlockEntity)drone).m_58899_();
            this.entityId = -1;
        } else {
            throw new IllegalArgumentException("drone must be an EntityDrone or ProgrammableControllerBlockEntity!");
        }
    }

    public PacketDroneDebugBase(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.entityId = buffer.readInt();
            this.pos = null;
        } else {
            this.pos = buffer.m_130135_();
            this.entityId = -1;
        }
    }

    PacketDroneDebugBase(int entityId, BlockPos pos) {
        this.entityId = entityId;
        this.pos = pos;
    }

    public void toBytes(FriendlyByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(false);
            buf.m_130064_(this.pos);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.entityId);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player player;
            Level world = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientLevel() : ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            Object object = player = ((NetworkEvent.Context)ctx.get()).getSender() == null ? ClientUtils.getClientPlayer() : ((NetworkEvent.Context)ctx.get()).getSender();
            if (this.entityId >= 0) {
                Entity entity = world.m_6815_(this.entityId);
                if (entity instanceof DroneEntity) {
                    this.handle(player, (IDroneBase)entity);
                }
            } else if (this.pos != null) {
                BlockEntity te = world.m_7702_(this.pos);
                if (te instanceof ProgrammableControllerBlockEntity) {
                    this.handle(player, (IDroneBase)te);
                }
            } else {
                this.handle(player, null);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    abstract void handle(Player var1, IDroneBase var2);
}

