/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationDoublePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketPlaySound
extends LocationDoublePacket {
    private final SoundEvent soundEvent;
    private final SoundSource category;
    private final float volume;
    private final float pitch;
    private final boolean distanceDelay;

    public PacketPlaySound(SoundEvent soundEvent, SoundSource category, double x, double y, double z, float volume, float pitch, boolean distanceDelay) {
        super(x, y, z);
        this.soundEvent = soundEvent;
        this.category = category;
        this.volume = volume;
        this.pitch = pitch;
        this.distanceDelay = distanceDelay;
    }

    public PacketPlaySound(SoundEvent soundEvent, SoundSource category, BlockPos pos, float volume, float pitch, boolean distanceDelay) {
        this(soundEvent, category, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), volume, pitch, distanceDelay);
    }

    public PacketPlaySound(FriendlyByteBuf buffer) {
        super(buffer);
        this.soundEvent = (SoundEvent)buffer.readRegistryIdSafe(SoundEvent.class);
        this.category = SoundSource.values()[buffer.readInt()];
        this.volume = buffer.readFloat();
        this.pitch = buffer.readFloat();
        this.distanceDelay = buffer.readBoolean();
    }

    @Override
    public void toBytes(FriendlyByteBuf buffer) {
        super.toBytes(buffer);
        buffer.writeRegistryId(ForgeRegistries.SOUND_EVENTS, (Object)this.soundEvent);
        buffer.writeInt(this.category.ordinal());
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        buffer.writeBoolean(this.distanceDelay);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientUtils.getClientLevel().m_7785_(this.x, this.y, this.z, this.soundEvent, this.category, this.volume, this.pitch, this.distanceDelay));
        ctx.get().setPacketHandled(true);
    }
}

