/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketSyncClassifyFilter {
    private final boolean matchAll;
    private final Set<ClassifyFilterItem.FilterCondition> conditions;
    private final InteractionHand handIn;

    public PacketSyncClassifyFilter(boolean matchAll, Set<ClassifyFilterItem.FilterCondition> conditions, InteractionHand handIn) {
        this.matchAll = matchAll;
        this.conditions = conditions;
        this.handIn = handIn;
    }

    public PacketSyncClassifyFilter(FriendlyByteBuf buf) {
        this.matchAll = buf.readBoolean();
        int n = buf.m_130242_();
        this.conditions = EnumSet.noneOf(ClassifyFilterItem.FilterCondition.class);
        for (int i = 0; i < n; ++i) {
            this.conditions.add((ClassifyFilterItem.FilterCondition)buf.m_130066_(ClassifyFilterItem.FilterCondition.class));
        }
        this.handIn = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.matchAll);
        buf.m_130130_(this.conditions.size());
        this.conditions.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130068_(arg_0));
        buf.writeBoolean(this.handIn == InteractionHand.MAIN_HAND);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (stack = player.m_21120_(this.handIn)).m_41720_() instanceof ClassifyFilterItem) {
                new ClassifyFilterItem.FilterSettings(this.matchAll, this.conditions).save(stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

