/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.api.crafting.recipe.PneumaticCraftRecipe;
import me.desht.pneumaticcraft.common.core.ModRecipeSerializers;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class HeatFrameCoolingRecipeImpl
extends HeatFrameCoolingRecipe {
    private static int maxThresholdTemp = Integer.MIN_VALUE;
    public final Ingredient input;
    private final int temperature;
    public final ItemStack output;
    private final float bonusMultiplier;
    private final float bonusLimit;

    public HeatFrameCoolingRecipeImpl(ResourceLocation id, Ingredient input, int temperature, ItemStack output) {
        this(id, input, temperature, output, 0.0f, 0.0f);
    }

    public HeatFrameCoolingRecipeImpl(ResourceLocation id, Ingredient input, int temperature, ItemStack output, float bonusMultiplier, float bonusLimit) {
        super(id);
        this.input = input;
        this.temperature = temperature;
        this.output = output;
        this.bonusMultiplier = bonusMultiplier;
        this.bonusLimit = bonusLimit;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getThresholdTemperature() {
        return this.temperature;
    }

    @Override
    public float getBonusMultiplier() {
        return this.bonusMultiplier;
    }

    @Override
    public float getBonusLimit() {
        return this.bonusLimit;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        this.input.m_43923_(buffer);
        buffer.writeInt(this.temperature);
        buffer.m_130055_(this.output);
        buffer.writeFloat(this.bonusMultiplier);
        buffer.writeFloat(this.bonusLimit);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.HEAT_FRAME_COOLING.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.HEAT_FRAME_COOLING.get();
    }

    public static <T extends Recipe<?>> void cacheMaxThresholdTemp(Collection<T> recipes) {
        maxThresholdTemp = Integer.MIN_VALUE;
        for (Recipe recipe : recipes) {
            HeatFrameCoolingRecipe hfcr;
            if (!(recipe instanceof HeatFrameCoolingRecipe) || (hfcr = (HeatFrameCoolingRecipe)recipe).getThresholdTemperature() <= maxThresholdTemp) continue;
            maxThresholdTemp = hfcr.getThresholdTemperature();
        }
    }

    public static int getMaxThresholdTemp(Level world) {
        if (maxThresholdTemp == Integer.MIN_VALUE) {
            HeatFrameCoolingRecipeImpl.cacheMaxThresholdTemp(ModRecipeTypes.getRecipes(world, ModRecipeTypes.HEAT_FRAME_COOLING));
        }
        return maxThresholdTemp;
    }

    public static class Serializer<T extends HeatFrameCoolingRecipe>
    implements RecipeSerializer<T> {
        private final IFactory<T> factory;

        public Serializer(IFactory<T> factory) {
            this.factory = factory;
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int maxTemp = GsonHelper.m_13824_((JsonObject)json, (String)"max_temp", (int)273);
            float bonusMultiplier = 0.0f;
            float bonusLimit = 0.0f;
            if (json.has("bonus_output")) {
                JsonObject bonus = json.getAsJsonObject("bonus_output");
                bonusMultiplier = GsonHelper.m_13915_((JsonObject)bonus, (String)"multiplier");
                bonusLimit = GsonHelper.m_13915_((JsonObject)bonus, (String)"limit");
            }
            return this.factory.create(recipeId, input, maxTemp, result, bonusMultiplier, bonusLimit);
        }

        @Nullable
        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int temperature = buffer.readInt();
            ItemStack out = buffer.m_130267_();
            float bonusMultiplier = buffer.readFloat();
            float bonusLimit = buffer.readFloat();
            return this.factory.create(recipeId, input, temperature, out, bonusMultiplier, bonusLimit);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((PneumaticCraftRecipe)recipe).write(buffer);
        }

        public static interface IFactory<T extends HeatFrameCoolingRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, int var3, ItemStack var4, float var5, float var6);
        }
    }
}

