/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei.transfer;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCrafting;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.runtime.IRecipesGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class ProgrammerTransferHandler
implements IRecipeTransferHandler<ProgrammerMenu, CraftingRecipe> {
    private static ProgrammerScreen programmerScreen = null;
    private final IRecipeTransferHandlerHelper transferHelper;

    public ProgrammerTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ProgrammerMenu> getContainerClass() {
        return ProgrammerMenu.class;
    }

    public Optional<MenuType<ProgrammerMenu>> getMenuType() {
        return Optional.of((MenuType)ModMenuTypes.PROGRAMMER.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(ProgrammerMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (programmerScreen != null) {
            IProgWidget craftingWidget;
            List<ProgWidgetItemFilter> params = this.makeFilterWidgets(craftingWidget, recipe, recipeSlots, (craftingWidget = this.findSuitableCraftingWidget(programmerScreen)) == null && !maxTransfer);
            if (params.isEmpty()) {
                return this.transferHelper.createInternalError();
            }
            if (doTransfer) {
                ProgrammerBlockEntity programmer = (ProgrammerBlockEntity)ProgrammerTransferHandler.programmerScreen.te;
                programmer.progWidgets.addAll(params);
                NetworkHandler.sendToServer(new PacketProgrammerUpdate(programmer));
                ProgrammerBlockEntity.updatePuzzleConnections(programmer.progWidgets);
            }
            return null;
        }
        return this.transferHelper.createInternalError();
    }

    private List<ProgWidgetItemFilter> makeFilterWidgets(IProgWidget craftingWidget, Object recipe, IRecipeSlotsView recipeSlotsView, boolean uniqueStacks) {
        PointXY base;
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        HashSet itemsSeen = new HashSet();
        recipeSlotsView.getSlotViews(RecipeIngredientRole.INPUT).forEach(view -> view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).ifPresentOrElse(stack -> {
            l.add(uniqueStacks && itemsSeen.contains(stack.m_41720_()) ? ItemStack.f_41583_ : stack);
            itemsSeen.add(stack.m_41720_());
        }, () -> l.add(ItemStack.f_41583_)));
        if (recipe instanceof ShapedRecipe) {
            if (l.size() != 9) {
                return Collections.emptyList();
            }
            for (int n = 0; n < 2; ++n) {
                if (!((ItemStack)l.get(0)).m_41619_() || !((ItemStack)l.get(3)).m_41619_() || !((ItemStack)l.get(6)).m_41619_()) continue;
                for (int i = 0; i < l.size(); ++i) {
                    if (i % 3 == 2) {
                        l.set(i, ItemStack.f_41583_);
                        continue;
                    }
                    if (i + 1 >= l.size()) continue;
                    l.set(i, (ItemStack)l.get(i + 1));
                }
            }
        }
        ProgWidgetItemFilter filterWidget = new ProgWidgetItemFilter();
        if (craftingWidget == null) {
            Rect2i bounds = programmerScreen.getProgrammerBounds();
            base = programmerScreen.mouseToWidgetCoords(programmerScreen.getGuiLeft() + bounds.m_110085_() + 50, programmerScreen.getGuiTop() + bounds.m_110086_() + 50, filterWidget);
        } else {
            base = new PointXY(craftingWidget.getX() + craftingWidget.getWidth() / 2, craftingWidget.getY());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        int c = 0;
        for (int n = 0; n < l.size(); ++n) {
            ItemStack stack = (ItemStack)l.get(n);
            if (stack.m_41619_() && (craftingWidget == null || n % 3 >= 2 || ((ItemStack)l.get(n + 1)).m_41619_())) continue;
            ProgWidgetItemFilter w = ProgWidgetItemFilter.withFilter(stack);
            if (craftingWidget == null) {
                w.setX(base.x() + c++ * filterWidget.getWidth() / 2);
                w.setY(base.y());
            } else {
                w.setX(base.x() + n % 3 * filterWidget.getWidth() / 2);
                w.setY(base.y() + n / 3 * filterWidget.getHeight() / 2);
            }
            builder.add((Object)w);
        }
        return builder.build();
    }

    private IProgWidget findSuitableCraftingWidget(ProgrammerScreen guiProgrammer) {
        return ((ProgrammerBlockEntity)ProgrammerTransferHandler.programmerScreen.te).progWidgets.stream().filter(w -> w instanceof ProgWidgetCrafting && guiProgrammer.isVisible((IProgWidget)w)).filter(w -> w.getConnectedParameters()[0] == null && w.getConnectedParameters()[1] == null && w.getConnectedParameters()[2] == null).findFirst().orElse(null);
    }

    public static class Listener {
        @SubscribeEvent
        public static void onGuiOpen(ScreenEvent.Opening event) {
            Screen screen;
            if (event.getScreen() instanceof IRecipesGui && (screen = Minecraft.m_91087_().f_91080_) instanceof ProgrammerScreen) {
                ProgrammerScreen p;
                programmerScreen = p = (ProgrammerScreen)screen;
            } else if (!(event.getScreen() instanceof IRecipesGui)) {
                programmerScreen = null;
            }
        }
    }
}

