/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class ClientMessageLaserColor {
    private final Map<AttachmentType, Integer> colorMap = new HashMap<AttachmentType, Integer>();
    private boolean applyGunColor = false;
    private int gunColor = 0;
    private int gunSlotIndex = -1;

    private ClientMessageLaserColor() {
    }

    public ClientMessageLaserColor(@NotNull ItemStack gun, int gunSlotIndex) {
        AttachmentType[] attachmentTypeArray = gun.m_41720_();
        if (attachmentTypeArray instanceof IGun) {
            IGun iGun = (IGun)attachmentTypeArray;
            for (AttachmentType type : AttachmentType.values()) {
                IAttachment iAttachment;
                ItemStack attachment = iGun.getAttachment(gun, type);
                Item item = attachment.m_41720_();
                if (!(item instanceof IAttachment) || !(iAttachment = (IAttachment)item).hasCustomLaserColor(attachment)) continue;
                this.colorMap.put(type, iAttachment.getLaserColor(attachment));
            }
            if (iGun.hasCustomLaserColor(gun)) {
                this.gunColor = iGun.getLaserColor(gun);
                this.applyGunColor = true;
            }
            this.gunSlotIndex = gunSlotIndex;
        }
    }

    public static void encode(ClientMessageLaserColor message, FriendlyByteBuf buf) {
        buf.m_236831_(message.colorMap, FriendlyByteBuf::m_130068_, FriendlyByteBuf::writeInt);
        buf.writeBoolean(message.applyGunColor);
        buf.writeInt(message.gunColor);
        buf.writeInt(message.gunSlotIndex);
    }

    public static ClientMessageLaserColor decode(FriendlyByteBuf buf) {
        ClientMessageLaserColor message = new ClientMessageLaserColor();
        message.colorMap.putAll(buf.m_236847_(buf1 -> (AttachmentType)buf.m_130066_(AttachmentType.class), FriendlyByteBuf::readInt));
        message.applyGunColor = buf.readBoolean();
        message.gunColor = buf.readInt();
        message.gunSlotIndex = buf.readInt();
        return message;
    }

    public static void handle(ClientMessageLaserColor message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null || message.gunSlotIndex == -1) {
                    return;
                }
                Inventory inventory = player.m_150109_();
                ItemStack gunItem = inventory.m_8020_(message.gunSlotIndex);
                IGun iGun = IGun.getIGunOrNull(gunItem);
                if (iGun != null) {
                    for (Map.Entry<AttachmentType, Integer> entry : message.colorMap.entrySet()) {
                        AttachmentType type = entry.getKey();
                        int color = entry.getValue();
                        ItemStack attachment = iGun.getAttachment(gunItem, type);
                        Item patt3420$temp = attachment.m_41720_();
                        if (!(patt3420$temp instanceof IAttachment)) continue;
                        IAttachment iAttachment = (IAttachment)patt3420$temp;
                        iAttachment.setLaserColor(attachment, color);
                    }
                    if (message.applyGunColor) {
                        iGun.setLaserColor(gunItem, message.gunColor);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

