/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.manager.JsonDataManager;
import com.tacz.guns.resource.network.DataType;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class CommonDataManager<T>
extends JsonDataManager<T>
implements INetworkCacheReloadListener {
    private final DataType type;
    protected Map<ResourceLocation, String> networkCache;

    public CommonDataManager(DataType type, Class<T> dataClass, Gson pGson, String directory, String marker) {
        super(dataClass, pGson, directory, marker);
        this.type = type;
    }

    public CommonDataManager(DataType type, Class<T> dataClass, Gson pGson, FileToIdConverter fileToIdConverter, String marker) {
        super(dataClass, pGson, fileToIdConverter, marker);
        this.type = type;
    }

    @Override
    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        super.apply(pObject, pResourceManager, pProfiler);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        pObject.forEach((id, element) -> builder.put(id, (Object)element.toString()));
        this.networkCache = builder.build();
    }

    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public Map<ResourceLocation, String> getNetworkCache() {
        return this.networkCache;
    }

    @Override
    public DataType getType() {
        return this.type;
    }
}

