/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.config.util.HeadShotAABBConfigRead;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.util.HitboxHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityUtil {
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();

    @Nullable
    public static EntityKineticBullet.EntityResult findEntityOnPath(Projectile bulletEntity, Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = bulletEntity.m_9236_().m_6249_((Entity)bulletEntity, bulletEntity.m_20191_().m_82369_(bulletEntity.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        Entity owner = bulletEntity.m_19749_();
        for (Entity entity : entities) {
            EntityKineticBullet.EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.m_20365_(owner) || (result = EntityUtil.getHitResult(bulletEntity, entity, startVec, endVec)) == null) continue;
            Vec3 hitPos = result.getHitPos();
            double distanceToHit = startVec.m_82554_(hitPos);
            if (!entity.m_6084_() || !(distanceToHit < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityKineticBullet.EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @NotNull
    public static List<EntityKineticBullet.EntityResult> findEntitiesOnPath(Projectile bulletEntity, Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityKineticBullet.EntityResult> hitEntities = new ArrayList<EntityKineticBullet.EntityResult>();
        List entities = bulletEntity.m_9236_().m_6249_((Entity)bulletEntity, bulletEntity.m_20191_().m_82369_(bulletEntity.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        Entity owner = bulletEntity.m_19749_();
        for (Entity entity : entities) {
            EntityKineticBullet.EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.m_20202_()) || (result = EntityUtil.getHitResult(bulletEntity, entity, startVec, endVec)) == null || !entity.m_6084_()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    protected static EntityKineticBullet.EntityResult getHitResult(Projectile bulletEntity, Entity entity, Vec3 startVec, Vec3 endVec) {
        AABB aabb;
        AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, bulletEntity.m_19749_());
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null) {
            return null;
        }
        Vec3 hitBoxPos = hitPos.m_82546_(entity.m_20182_());
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId != null && (aabb = HeadShotAABBConfigRead.getAABB(entityId)) != null) {
            return new EntityKineticBullet.EntityResult(entity, hitPos, aabb.m_82390_(hitBoxPos));
        }
        boolean headshot = false;
        float eyeHeight = entity.m_20192_();
        if ((double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.25) {
            headshot = true;
        }
        return new EntityKineticBullet.EntityResult(entity, hitPos, headshot);
    }
}

