/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.platform.RegistryWrappers;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class CableBlockItem
extends BlockItem {
    @Nullable
    private String translationKey;

    public CableBlockItem(CableBlock block, Item.Properties settings) {
        super((Block)block, settings);
    }

    boolean placeAt(Level world, BlockPos pos, BlockState state) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            return false;
        }
        world.m_46597_(pos, state);
        SoundType soundType = state.m_60734_().m_49962_(state);
        world.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)tile;
            cable.connectionsChanged();
        }
        return true;
    }

    boolean placeAtCorrected(Level world, BlockPos pos, BlockState state) {
        return this.placeAt(world, pos, CableBlock.correctConnections(world, pos, state));
    }

    public String m_5524_() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"block", (ResourceLocation)RegistryWrappers.ITEMS.getKey((Item)this));
        }
        return this.translationKey;
    }

    public static class Cable
    extends CableBlockItem {
        public Cable(CableBlock block, Item.Properties settings) {
            super(block, settings);
        }

        public InteractionResult m_40576_(BlockPlaceContext context) {
            BlockPos pos;
            BlockPos insidePos;
            ItemStack stack = context.m_43722_();
            if (stack.m_41619_()) {
                return InteractionResult.FAIL;
            }
            Level world = context.m_43725_();
            BlockState insideState = world.m_8055_(insidePos = (pos = context.m_8083_()).m_121945_(context.m_43719_().m_122424_()));
            if (insideState.m_60734_() == ModRegistry.Blocks.CABLE.get() && !((Boolean)insideState.m_61143_((Property)CableBlock.CABLE)).booleanValue() && this.placeAtCorrected(world, insidePos, (BlockState)insideState.m_61124_((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            BlockState existingState = world.m_8055_(pos);
            if (existingState.m_60734_() == ModRegistry.Blocks.CABLE.get() && !((Boolean)existingState.m_61143_((Property)CableBlock.CABLE)).booleanValue() && this.placeAtCorrected(world, pos, (BlockState)existingState.m_61124_((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return super.m_40576_(context);
        }
    }

    public static class WiredModem
    extends CableBlockItem {
        public WiredModem(CableBlock block, Item.Properties settings) {
            super(block, settings);
        }

        public InteractionResult m_40576_(BlockPlaceContext context) {
            Direction side;
            BlockState newState;
            BlockPos pos;
            ItemStack stack = context.m_43722_();
            if (stack.m_41619_()) {
                return InteractionResult.FAIL;
            }
            Level world = context.m_43725_();
            BlockState existingState = world.m_8055_(pos = context.m_8083_());
            if (existingState.m_60734_() == ModRegistry.Blocks.CABLE.get() && existingState.m_61143_(CableBlock.MODEM) == CableModemVariant.None && this.placeAt(world, pos, newState = (BlockState)((BlockState)existingState.m_61124_(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.from(side = context.m_43719_().m_122424_())))).m_61124_((Property)CableBlock.CONNECTIONS.get(side), (Comparable)((Boolean)existingState.m_61143_((Property)CableBlock.CABLE))))) {
                stack.m_41774_(1);
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return super.m_40576_(context);
        }
    }
}

