/*
 * Decompiled with CFR 0.152.
 */
package wily.mozombieswave;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import wily.mozombieswave.Config;
import wily.mozombieswave.MoZombiesPlatform;
import wily.mozombieswave.MoZombiesWave;

public class ForgeConfigCompat {
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec.BooleanValue checkUpdates;
    public static ForgeConfigSpec.BooleanValue oldDwarfZombieModel;
    private static final String CATEGORY_UPDATES = "updates";
    private static final String CATEGORY_GENERAL = "general";

    public static void loadConfig(ForgeConfigSpec spec, Path path) {
        MoZombiesWave.LOGGER.debug("Loading config file {}", (Object)path);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        MoZombiesWave.LOGGER.debug("Built TOML config for {}", (Object)path.toString());
        configData.load();
        MoZombiesWave.LOGGER.debug("Loaded TOML config file {}", (Object)path.toString());
        spec.setConfig((CommentedConfig)configData);
    }

    public static void loadAllSyncConfigs() {
        ForgeConfigCompat.loadConfig(CLIENT_CONFIG, MoZombiesPlatform.getConfigDirectory().resolve("mozombies_wave-client.toml"));
        ForgeConfigCompat.loadConfig(COMMON_CONFIG, MoZombiesPlatform.getConfigDirectory().resolve("mozombies_wave-common.toml"));
    }

    public static void setupConfig() {
        ForgeConfigCompat.loadAllSyncConfigs();
        Config.checkUpdates = (Boolean)checkUpdates.get();
        Config.oldDwarfZombieModel = (Boolean)oldDwarfZombieModel.get();
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER.comment("Settings").push(CATEGORY_GENERAL);
        oldDwarfZombieModel = CLIENT_BUILDER.comment("Changes the Zombie Dwarf model to a standard zombie model.\n Default: false\n Note: This don't change his collision box").define("oldZombieDwarfModel", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Update Checker Settings").push(CATEGORY_UPDATES);
        checkUpdates = COMMON_BUILDER.comment(" true = check for updates, false = don't check for updates.\n Default: true.").define("check_updates.updates", true);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

