/*
 * Decompiled with CFR 0.152.
 */
package wily.mozombieswave.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.mozombieswave.init.Registration;

public class Survivor
extends AgeableMob
implements NeutralMob {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(Survivor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt ALERT_INTERVAL = TimeUtil.m_145020_((int)4, (int)6);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int ticksUntilNextAlert;
    public static String name = "survivor";
    public static final int ID = 27;
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);
    private UUID persistentAngerTarget;
    private int remainingPersistentAngerTime;

    public Survivor(EntityType<Survivor> entityType, Level world) {
        super(entityType, world);
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        Survivor survivor = new Survivor(Registration.SURVIVOR.get(), (Level)p_146743_);
        survivor.m_6518_((ServerLevelAccessor)p_146743_, p_146743_.m_6436_(survivor.m_20183_()), MobSpawnType.BREEDING, null, null);
        return survivor;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)0);
    }

    public boolean m_21531_() {
        return true;
    }

    public int getSurvivorType() {
        return (Integer)this.m_20088_().m_135370_(DATA_TYPE_ID);
    }

    public void setSurvivorType(int type) {
        this.m_20088_().m_135381_(DATA_TYPE_ID, (Object)type);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((float)this.f_21364_ * 2.5f);
        }
        return super.m_213860_();
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_230260_1_) {
        this.remainingPersistentAngerTime = p_230260_1_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID p_230259_1_) {
        this.persistentAngerTarget = p_230259_1_;
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128405_("Type", this.getSurvivorType());
        this.m_21678_(p_213281_1_);
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.setSurvivorType(p_70037_1_.m_128451_("Type"));
        if (!this.m_9236_().f_46443_) {
            this.m_147285_(this.m_9236_(), p_70037_1_);
        }
    }

    public void m_6710_(@Nullable LivingEntity p_70624_1_) {
        if (this.m_5448_() == null && p_70624_1_ != null) {
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
        if (p_70624_1_ instanceof Player) {
            this.m_6598_((Player)p_70624_1_);
        }
        super.m_6710_(p_70624_1_);
    }

    protected void updateNoActionTime() {
        float f = this.m_213856_();
        if (f > 0.5f) {
            this.f_20891_ += 2;
        }
    }

    public void m_8107_() {
        this.m_21203_();
        this.updateNoActionTime();
        if (this.m_21205_().m_41614_() && this.m_21223_() <= this.m_21233_()) {
            this.m_5584_(this.m_9236_(), this.m_21205_());
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22279_);
        if (this.m_21660_()) {
            if (!this.m_6162_() && !modifiableattributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                modifiableattributeinstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        } else if (modifiableattributeinstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
            modifiableattributeinstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        }
        this.m_21666_((ServerLevel)this.m_9236_(), true);
        if (this.m_5448_() != null) {
            this.maybeAlertOthers();
        }
        if (this.m_21660_()) {
            this.f_20889_ = this.f_19797_;
        }
    }

    private void maybeAlertOthers() {
        if (this.ticksUntilNextAlert > 0) {
            --this.ticksUntilNextAlert;
        } else {
            if (this.m_21574_().m_148306_((Entity)this.m_5448_())) {
                this.alertOthers();
            }
            this.ticksUntilNextAlert = ALERT_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    private void alertOthers() {
        double d0 = this.m_21133_(Attributes.f_22277_);
        AABB axisalignedbb = AABB.m_82333_((Vec3)this.m_20182_()).m_82377_(d0, 10.0, d0);
        this.m_9236_().m_45976_(Survivor.class, axisalignedbb).stream().filter(p_241408_1_ -> p_241408_1_ != this).filter(p_241407_0_ -> p_241407_0_.m_5448_() == null).filter(p_241406_1_ -> !p_241406_1_.m_7307_((Entity)this.m_5448_())).forEach(p_241405_1_ -> p_241405_1_.m_6710_(this.m_5448_()));
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        super.m_213945_(this.f_19796_, difficulty);
        float f = this.f_19796_.m_188501_();
        float f2 = this.m_9236_().m_46791_() == Difficulty.HARD ? 0.45f : 0.2f;
        if (f < f2) {
            int i = this.f_19796_.m_188503_(3);
            if (i == 0) {
                if (this.f_19796_.m_188501_() < 0.25f) {
                    this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
                }
                if (this.f_19796_.m_188501_() < 0.15f) {
                    this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
                }
                if (this.f_19796_.m_188501_() < 0.3f) {
                    this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42383_));
            } else {
                this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42462_));
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42407_));
                if (this.f_19796_.m_188501_() < 0.3f) {
                    this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42408_));
                }
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
            }
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        float f = p_146747_.m_19057_();
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * f);
        if (p_146749_ == null) {
            p_146749_ = new GroupData(true, true, (double)p_146746_.m_213780_().m_188501_() < 0.4 ? 1 : 0);
        }
        GroupData survivorentity$groupdata = (GroupData)((Object)p_146749_);
        this.setSurvivorType(survivorentity$groupdata.Type);
        if (survivorentity$groupdata.canSpawnJockey) {
            if ((double)p_146746_.m_213780_().m_188501_() < 0.05) {
                List list = p_146746_.m_6443_(Horse.class, this.m_20191_().m_82377_(5.0, 3.0, 5.0), EntitySelector.f_20404_);
                if (!list.isEmpty()) {
                    Horse Horse2 = (Horse)list.get(0);
                    Horse2.m_30651_(true);
                    this.m_20329_((Entity)Horse2);
                }
            } else if ((double)p_146746_.m_213780_().m_188501_() < 0.05) {
                Horse Horse1 = (Horse)EntityType.f_20457_.m_20615_(this.m_9236_());
                Horse1.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                Horse1.m_6518_(p_146746_, p_146747_, MobSpawnType.JOCKEY, (SpawnGroupData)null, (CompoundTag)null);
                Horse1.m_30651_(true);
                this.m_20329_((Entity)Horse1);
                p_146746_.m_7967_((Entity)Horse1);
            }
        }
        if (survivorentity$groupdata.m_146779_() && this.f_19796_.m_188501_() <= survivorentity$groupdata.m_146780_()) {
            this.m_146762_(-24000);
            this.m_6863_(true);
        }
        this.m_213945_(this.f_19796_, p_146747_);
        return super.m_6518_(p_146746_, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        ItemStack itemstack;
        Creeper creeperentity;
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
        Entity entity = p_213333_1_.m_7639_();
        if (entity instanceof Creeper && (creeperentity = (Creeper)entity).m_32313_() && !(itemstack = this.getSkull()).m_41619_()) {
            creeperentity.m_32314_();
            this.m_19983_(itemstack);
        }
    }

    protected ItemStack getSkull() {
        return new ItemStack((ItemLike)Items.f_42680_, 1);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        if (this.getSurvivorType() >= 1) {
            return Registration.HURT_SURVIVOR_FEMALE.get();
        }
        return Registration.HURT_SURVIVOR.get();
    }

    public SoundEvent m_5592_() {
        return SoundEvents.f_12322_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Survivor)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        if (this.f_19796_.m_188501_() < 0.5f) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        } else {
            this.f_21346_.m_25352_(3, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        }
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 0.0).m_22266_(Attributes.f_22287_).m_22268_(Attributes.f_22276_, 20.0);
    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final boolean canSpawnJockey;
        public final int Type;

        public GroupData(boolean p_i231567_2_, boolean shouldSpawnBaby, int p_i231567_3_) {
            super(shouldSpawnBaby);
            this.canSpawnJockey = p_i231567_2_;
            this.Type = p_i231567_3_;
        }
    }

    public static class SurvivorRenderer
    extends HumanoidMobRenderer<Survivor, SurvivorModel<Survivor>> {
        int type = 0;
        SurvivorModel<Survivor> slim;
        SurvivorModel<Survivor> normal = (SurvivorModel)this.m_7200_();

        public SurvivorRenderer(EntityRendererProvider.Context context) {
            this(context, ModelLayers.f_171162_, ModelLayers.f_171164_, ModelLayers.f_171165_);
            this.slim = new SurvivorModel(context.m_174023_(ModelLayers.f_171166_));
        }

        public SurvivorRenderer(EntityRendererProvider.Context p_174458_, ModelLayerLocation layerLocation, ModelLayerLocation innerLayerLocation, ModelLayerLocation outerLayerLocation) {
            super(p_174458_, new SurvivorModel(p_174458_.m_174023_(layerLocation)), 0.5f);
            this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new SurvivorModel(p_174458_.m_174023_(innerLayerLocation)), new SurvivorModel(p_174458_.m_174023_(outerLayerLocation)), Minecraft.m_91087_().m_91304_()));
        }

        public void render(Survivor p_115455_, float p_115456_, float p_115457_, PoseStack p_115458_, MultiBufferSource p_115459_, int p_115460_) {
            this.type = p_115455_.getSurvivorType();
            this.f_115290_ = this.type >= 1 ? this.slim : this.normal;
            super.m_7392_((Mob)p_115455_, p_115456_, p_115457_, p_115458_, p_115459_, p_115460_);
        }

        public ResourceLocation getTextureLocation(Survivor entity) {
            return new ResourceLocation("mozombies_wave", "textures/entity/" + name + "_" + this.type + ".png");
        }
    }

    public static class SurvivorModel<S extends Survivor>
    extends HumanoidModel<S> {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("mozombies_wave", name), "main");

        public SurvivorModel(ModelPart p_170677_) {
            super(p_170677_);
        }

        public void m_7695_(PoseStack p_102034_, VertexConsumer p_102035_, int p_102036_, int p_102037_, float p_102038_, float p_102039_, float p_102040_, float p_102041_) {
            super.m_7695_(p_102034_, p_102035_, p_102036_, p_102037_, p_102038_, p_102039_, p_102040_, p_102041_);
        }
    }
}

