/*
 * Decompiled with CFR 0.152.
 */
package wily.mozombieswave.forge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import wily.mozombieswave.init.Registration;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MoZombiesPlatformImpl {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"mozombies_wave");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mozombies_wave");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"mozombies_wave");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"mozombies_wave");
    public static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"mozombies_wave");
    public static RegistryObject<Codec<SimpleBiomeModifier>> GHOST_CODEC_MODIFIER = BIOME_MODIFIER_SERIALIZER.register("spawn_all_biomes", () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(SimpleBiomeModifier::biomes), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(SimpleBiomeModifier::spawners)).apply((Applicative)builder, SimpleBiomeModifier::new)));

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Supplier<Item> registerItem(String name, Supplier<Item> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends LivingEntity> Supplier<EntityType<T>> registerEntityType(String name, Supplier<EntityType<T>> entity) {
        return ENTITIES.register(name, entity);
    }

    public static Supplier<SoundEvent> registerSoundEvent(String name, Supplier<SoundEvent> sound) {
        return SOUNDS.register(name, sound);
    }

    public static Supplier<CreativeModeTab> registerCreativeTab(String name, Supplier<CreativeModeTab> sound) {
        return CREATIVE_TABS.register(name, sound);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Registration.onEntityJoinWorld(event.getEntity(), event.getLevel());
    }

    public static void init(IEventBus bus) {
        ITEMS.register(bus);
        SOUNDS.register(bus);
        ENTITIES.register(bus);
        BIOME_MODIFIER_SERIALIZER.register(bus);
    }

    public static SpawnEggItem getPlatformSpawnEgg(Supplier<? extends EntityType<? extends Mob>> entityType, int i, int j, Item.Properties properties) {
        return new ForgeSpawnEggItem(entityType, i, j, properties);
    }

    public record SimpleBiomeModifier(HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
    {
        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
                for (MobSpawnSettings.SpawnerData spawn : this.spawners) {
                    if (this.biomes.m_203333_(biome) || biome.m_203656_(BiomeTags.f_215818_)) continue;
                    spawns.m_48376_(spawn.f_48404_.m_20674_(), spawn);
                }
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)GHOST_CODEC_MODIFIER.get();
        }
    }
}

