/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.api.unstable.animation.AnimationOption;
import com.alrex.parcool.api.unstable.animation.AnimationPart;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerModelTransformer {
    private final Player player;
    private final PlayerModel model;
    private final float partial;
    private final float ageInTicks;
    private final float limbSwing;
    private final float limbSwingAmount;
    private final float netHeadYaw;
    private final float headPitch;
    private AnimationOption option = new AnimationOption();

    public float getPartialTick() {
        return this.partial;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public float getNetHeadYaw() {
        return this.netHeadYaw;
    }

    public float getLimbSwing() {
        return this.limbSwing;
    }

    public float getLimbSwingAmount() {
        return this.limbSwingAmount;
    }

    public PlayerModel getRawModel() {
        return this.model;
    }

    public PlayerModelTransformer(Player player, PlayerModel model, boolean slim, float ageInTicks, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        this.player = player;
        this.model = model;
        this.partial = Minecraft.m_91087_().m_91296_();
        this.ageInTicks = ageInTicks;
        this.limbSwing = limbSwing;
        this.limbSwingAmount = limbSwingAmount;
        this.netHeadYaw = netHeadYaw;
        this.headPitch = headPitch;
    }

    public void setOption(AnimationOption option) {
        this.option = option;
    }

    public PlayerModelTransformer rotateRightArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelPart rightArm = this.model.f_102811_;
        if (rightArm.f_104207_) {
            this.setRotations(rightArm, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateRightArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelPart rightArm = this.model.f_102811_;
        if (rightArm.f_104207_) {
            this.setRotations(rightArm, MathUtil.lerp(rightArm.f_104203_, angleX, factor), MathUtil.lerp(rightArm.f_104204_, angleY, factor), MathUtil.lerp(rightArm.f_104205_, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelPart leftArm = this.model.f_102812_;
        if (leftArm.f_104207_) {
            this.setRotations(leftArm, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelPart leftArm = this.model.f_102812_;
        if (leftArm.f_104207_) {
            this.setRotations(leftArm, MathUtil.lerp(leftArm.f_104203_, angleX, factor), MathUtil.lerp(leftArm.f_104204_, angleY, factor), MathUtil.lerp(leftArm.f_104205_, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateRightLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelPart rightLeg = this.model.f_102813_;
        if (rightLeg.f_104207_) {
            this.setRotations(rightLeg, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateRightLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelPart rightLeg = this.model.f_102813_;
        if (rightLeg.f_104207_) {
            this.setRotations(rightLeg, MathUtil.lerp(rightLeg.f_104203_, angleX, factor), MathUtil.lerp(rightLeg.f_104204_, angleY, factor), MathUtil.lerp(rightLeg.f_104205_, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelPart leftLeg = this.model.f_102814_;
        if (leftLeg.f_104207_) {
            this.setRotations(leftLeg, angleX, angleY, angleZ);
        }
        return this;
    }

    public PlayerModelTransformer rotateLeftLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelPart leftLeg = this.model.f_102814_;
        if (leftLeg.f_104207_) {
            this.setRotations(leftLeg, MathUtil.lerp(leftLeg.f_104203_, angleX, factor), MathUtil.lerp(leftLeg.f_104204_, angleY, factor), MathUtil.lerp(leftLeg.f_104205_, angleZ, factor));
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        ModelPart arm = this.model.f_102811_;
        if (arm.f_104207_) {
            this.setRotations(arm, arm.f_104203_ + angleX, arm.f_104204_ + angleY, arm.f_104205_ + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateLeftArm(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        ModelPart arm = this.model.f_102812_;
        if (arm.f_104207_) {
            this.setRotations(arm, arm.f_104203_ + angleX, arm.f_104204_ + angleY, arm.f_104205_ + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        ModelPart leg = this.model.f_102813_;
        if (leg.f_104207_) {
            this.setRotations(leg, leg.f_104203_ + angleX, leg.f_104204_ + angleY, leg.f_104205_ + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateLeftLeg(float angleX, float angleY, float angleZ) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        ModelPart leg = this.model.f_102814_;
        if (leg.f_104207_) {
            this.setRotations(leg, leg.f_104203_ + angleX, leg.f_104204_ + angleY, leg.f_104205_ + angleZ);
        }
        return this;
    }

    public PlayerModelTransformer addRotateRightArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        return this.addRotateRightArm(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateLeftArm(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        return this.addRotateLeftArm(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateRightLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        return this.addRotateRightLeg(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer addRotateLeftLeg(float angleX, float angleY, float angleZ, float factor) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        return this.addRotateLeftLeg(angleX * factor, angleY * factor, angleZ * factor);
    }

    public PlayerModelTransformer makeArmsNatural() {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        AnimationUtils.m_102082_((ModelPart)this.model.f_102811_, (ModelPart)this.model.f_102812_, (float)this.ageInTicks);
        return this;
    }

    public PlayerModelTransformer makeLegsMoveDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.model.f_102813_.f_104205_ += Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102814_.f_104205_ -= Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102813_.f_104203_ += Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        this.model.f_102814_.f_104203_ -= Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        return this;
    }

    public PlayerModelTransformer makeArmsMoveDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        this.model.f_102811_.f_104205_ += Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102812_.f_104205_ -= Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102811_.f_104203_ += Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        this.model.f_102812_.f_104203_ -= Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor;
        return this;
    }

    public PlayerModelTransformer makeLegsLittleMoving() {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        AnimationUtils.m_102082_((ModelPart)this.model.f_102813_, (ModelPart)this.model.f_102814_, (float)this.ageInTicks);
        return this;
    }

    public PlayerModelTransformer makeLegsShakingDynamically(float factor) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.model.f_102813_.f_104205_ += Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102814_.f_104205_ += Mth.m_14089_((float)(this.ageInTicks * 0.56f)) * 0.8f * factor + 0.05f;
        this.model.f_102813_.f_104203_ += Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.2f * factor;
        this.model.f_102814_.f_104203_ -= Mth.m_14031_((float)(this.ageInTicks * 0.56f)) * 0.2f * factor;
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadPitch(float pitchDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104203_ = (float)Math.toRadians(pitchDegree + this.headPitch);
        return this;
    }

    public PlayerModelTransformer rotateHeadPitch(float pitchDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104203_ = (float)Math.toRadians(pitchDegree);
        return this;
    }

    public PlayerModelTransformer rotateHeadYaw(float yawDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104204_ = (float)Math.toRadians(yawDegree);
        return this;
    }

    public PlayerModelTransformer rotateHeadYawRadian(float yawRadian) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104204_ = yawRadian;
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadYaw(float yawDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104204_ = (float)Math.toRadians(yawDegree + this.netHeadYaw);
        return this;
    }

    public PlayerModelTransformer rotateAdditionallyHeadRoll(float rollDegree) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.model.f_102808_.f_104205_ = (float)Math.toRadians(rollDegree + this.netHeadYaw);
        return this;
    }

    public PlayerModelTransformer translateRightArm(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.RIGHT_ARM)) {
            return this;
        }
        this.getRawModel().f_102811_.f_104200_ += xOffset;
        this.getRawModel().f_102811_.f_104201_ += yOffset;
        this.getRawModel().f_102811_.f_104202_ += zOffset;
        return this;
    }

    public PlayerModelTransformer translateLeftArm(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.LEFT_ARM)) {
            return this;
        }
        this.getRawModel().f_102812_.f_104200_ += xOffset;
        this.getRawModel().f_102812_.f_104201_ += yOffset;
        this.getRawModel().f_102812_.f_104202_ += zOffset;
        return this;
    }

    public PlayerModelTransformer translateRightLeg(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.RIGHT_LEG)) {
            return this;
        }
        this.getRawModel().f_102813_.f_104200_ += xOffset;
        this.getRawModel().f_102813_.f_104201_ += yOffset;
        this.getRawModel().f_102813_.f_104202_ += zOffset;
        return this;
    }

    public PlayerModelTransformer translateLeftLeg(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.LEFT_LEG)) {
            return this;
        }
        this.getRawModel().f_102814_.f_104200_ += xOffset;
        this.getRawModel().f_102814_.f_104201_ += yOffset;
        this.getRawModel().f_102814_.f_104202_ += zOffset;
        return this;
    }

    public PlayerModelTransformer translateHead(float xOffset, float yOffset, float zOffset) {
        if (this.option.isCanceled(AnimationPart.HEAD)) {
            return this;
        }
        this.getRawModel().f_102808_.f_104200_ += xOffset;
        this.getRawModel().f_102808_.f_104201_ += yOffset;
        this.getRawModel().f_102808_.f_104202_ += zOffset;
        return this;
    }

    public void end() {
    }

    public void copyFromBodyToWear() {
        this.model.f_103375_.m_104315_(this.model.f_102811_);
        this.model.f_103374_.m_104315_(this.model.f_102812_);
        this.model.f_103377_.m_104315_(this.model.f_102813_);
        this.model.f_103376_.m_104315_(this.model.f_102814_);
        this.model.f_103378_.m_104315_(this.model.f_102810_);
        this.model.f_102809_.m_104315_(this.model.f_102808_);
    }

    private void setRotations(ModelPart renderer, float angleX, float angleY, float angleZ) {
        renderer.f_104203_ = angleX;
        renderer.f_104204_ = angleY;
        renderer.f_104205_ = angleZ;
    }

    public void reset() {
        this.resetModel(this.model.f_102808_);
        this.resetModel(this.model.f_102809_);
        this.resetModel(this.model.f_103378_);
        this.resetModel(this.model.f_102810_);
        this.resetModel(this.model.f_102811_);
        this.model.f_102811_.f_104200_ = -5.0f;
        this.model.f_102811_.f_104201_ = 2.0f;
        this.model.f_102811_.f_104202_ = 0.0f;
        this.model.f_103375_.m_104315_(this.model.f_102811_);
        this.resetModel(this.model.f_102812_);
        this.model.f_102812_.f_104200_ = 5.0f;
        this.model.f_102812_.f_104201_ = 2.0f;
        this.model.f_102812_.f_104202_ = 0.0f;
        this.model.f_103374_.m_104315_(this.model.f_102812_);
        this.resetModel(this.model.f_102814_);
        this.model.f_102814_.f_104200_ = 1.9f;
        this.model.f_102814_.f_104201_ = 12.0f;
        this.model.f_102814_.f_104202_ = 0.0f;
        this.model.f_103376_.m_104315_(this.model.f_102814_);
        this.resetModel(this.model.f_102813_);
        this.model.f_102813_.f_104200_ = -1.9f;
        this.model.f_102813_.f_104201_ = 12.0f;
        this.model.f_102813_.f_104202_ = 0.0f;
        this.model.f_103377_.m_104315_(this.model.f_102813_);
    }

    public void resetModel(ModelPart model) {
        model.f_104203_ = 0.0f;
        model.f_104204_ = 0.0f;
        model.f_104205_ = 0.0f;
        model.f_104200_ = 0.0f;
        model.f_104201_ = 0.0f;
        model.f_104202_ = 0.0f;
    }
}

