/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.block.zipline;

import com.alrex.parcool.common.block.zipline.ZiplineHookBlock;
import com.alrex.parcool.common.block.zipline.ZiplineInfo;
import com.alrex.parcool.common.entity.zipline.ZiplineRopeEntity;
import com.alrex.parcool.common.item.Items;
import com.alrex.parcool.common.item.zipline.ZiplineRopeItem;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ZiplineHookTileEntity
extends BlockEntity {
    private final TreeMap<BlockPos, ZiplineInfo> connections = new TreeMap();
    private final TreeMap<BlockPos, ZiplineRopeEntity> connectionEntities = new TreeMap();

    public ZiplineHookTileEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public Set<BlockPos> getConnectionPoints() {
        return this.connections.keySet();
    }

    private TreeMap<BlockPos, ZiplineInfo> getConnectionInfo() {
        return this.connections;
    }

    public List<ItemStack> removeAllConnection() {
        if (this.f_58857_ == null) {
            return Collections.EMPTY_LIST;
        }
        this.getConnectionPoints().stream().filter(arg_0 -> ((Level)this.f_58857_).m_46749_(arg_0)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).map(it -> it instanceof ZiplineHookTileEntity ? (ZiplineHookTileEntity)((Object)it) : null).filter(Objects::nonNull).forEach(it -> it.onPairHookRegistrationRemoved(this));
        List itemStacks = Collections.EMPTY_LIST;
        if (!this.f_58857_.m_5776_()) {
            this.connectionEntities.values().forEach(it -> it.m_142687_(Entity.RemovalReason.DISCARDED));
            itemStacks = this.getConnectionInfo().values().stream().map(it -> {
                ItemStack stack = new ItemStack(() -> Items.ZIPLINE_ROPE.get());
                ZiplineRopeItem.setColor(stack, it.getColor());
                return stack;
            }).collect(Collectors.toList());
        }
        this.connectionEntities.clear();
        this.getConnectionInfo().clear();
        this.m_6596_();
        return itemStacks;
    }

    private void onPairHookRegistrationRemoved(ZiplineHookTileEntity removedPair) {
        this.getConnectionPoints().remove(removedPair.m_58899_());
        this.connectionEntities.remove(removedPair.m_58899_());
        this.m_6596_();
    }

    private void onPairHookUnloaded(ZiplineHookTileEntity removedPair) {
        this.connectionEntities.remove(removedPair.m_58899_());
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.f_58857_ != null) {
            this.getConnectionPoints().stream().filter(arg_0 -> ((Level)this.f_58857_).m_46749_(arg_0)).map(arg_0 -> ((Level)this.f_58857_).m_7702_(arg_0)).map(it -> it instanceof ZiplineHookTileEntity ? (ZiplineHookTileEntity)((Object)it) : null).filter(Objects::nonNull).forEach(it -> it.onPairHookUnloaded(this));
            if (!this.f_58857_.m_5776_()) {
                this.connectionEntities.values().forEach(it -> it.m_142687_(Entity.RemovalReason.DISCARDED));
            }
            this.connectionEntities.clear();
        }
    }

    public Vec3 getActualZiplinePoint(@Nullable BlockPos connected) {
        BlockState state;
        Block block;
        if (this.f_58857_ == null) {
            new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        }
        if ((block = (state = this.f_58857_.m_8055_(this.m_58899_())).m_60734_()) instanceof ZiplineHookBlock) {
            return ((ZiplineHookBlock)block).getActualZiplinePoint(this.m_58899_(), state);
        }
        return new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
    }

    public boolean connectTo(ZiplineHookTileEntity target, ZiplineInfo info) {
        if (this == target) {
            return false;
        }
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            if (this.getConnectionPoints().stream().anyMatch(arg_0 -> ((BlockPos)target.m_58899_()).equals(arg_0))) {
                return false;
            }
            ZiplineRopeEntity ropeEntity = this.spawnRope(this.f_58857_, target, info);
            if (ropeEntity != null) {
                this.getConnectionInfo().put(target.m_58899_(), info);
                this.m_6596_();
                target.getConnectionInfo().put(this.m_58899_(), info);
                target.m_6596_();
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ZiplineRopeEntity spawnRope(Level level, ZiplineHookTileEntity target, ZiplineInfo info) {
        if (level.m_5776_()) {
            return null;
        }
        if (target.connectionEntities.containsKey(this.m_58899_())) {
            return null;
        }
        ZiplineRopeEntity entity = new ZiplineRopeEntity(level, this.m_58899_(), target.m_58899_(), info);
        boolean result = level.m_7967_((Entity)entity);
        if (result) {
            this.connectionEntities.put(target.m_58899_(), entity);
            target.connectionEntities.put(this.m_58899_(), entity);
        }
        return result ? entity : null;
    }

    private void saveTo(CompoundTag nbt) {
        ListTag connections = new ListTag();
        for (Map.Entry<BlockPos, ZiplineInfo> infoEntry : this.getConnectionInfo().entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("X", infoEntry.getKey().m_123341_());
            entryTag.m_128405_("Y", infoEntry.getKey().m_123342_());
            entryTag.m_128405_("Z", infoEntry.getKey().m_123343_());
            entryTag.m_128365_("Info", infoEntry.getValue().save());
            connections.add((Object)entryTag);
        }
        nbt.m_128365_("Connection", (Tag)connections);
    }

    private void restoreFrom(CompoundTag nbt) {
        Tag connections = nbt.m_128423_("Connection");
        if (!(connections instanceof ListTag)) {
            return;
        }
        ListTag listConnections = (ListTag)connections;
        this.getConnectionInfo().clear();
        for (Tag entry : listConnections) {
            CompoundTag cTag;
            if (!(entry instanceof CompoundTag) || !(cTag = (CompoundTag)entry).m_128441_("X") || !cTag.m_128441_("Y") || !cTag.m_128441_("Z")) continue;
            BlockPos pos = new BlockPos(cTag.m_128451_("X"), cTag.m_128451_("Y"), cTag.m_128451_("Z"));
            ZiplineInfo info = ZiplineInfo.load(cTag.m_128423_("Info"));
            this.getConnectionInfo().put(pos, info);
        }
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        this.saveTo(nbt);
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.restoreFrom(nbt);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        this.saveTo(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.restoreFrom(tag);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BlockEntity entity) {
        if (!(entity instanceof ZiplineHookTileEntity)) {
            return;
        }
        ZiplineHookTileEntity self = (ZiplineHookTileEntity)entity;
        if (level != null && !level.m_5776_()) {
            self.connectionEntities.values().removeIf(it -> !it.m_6084_());
            if (self.connectionEntities.size() < self.getConnectionPoints().size()) {
                List<ZiplineHookTileEntity> tileEntities = self.getConnectionPoints().stream().filter(it -> !self.connectionEntities.containsKey(it)).filter(arg_0 -> ((Level)level).m_46749_(arg_0)).map(arg_0 -> ((Level)level).m_7702_(arg_0)).map(it -> it instanceof ZiplineHookTileEntity ? (ZiplineHookTileEntity)((Object)it) : null).filter(Objects::nonNull).toList();
                tileEntities.forEach(it -> {
                    if (it.getConnectionPoints().contains(self.m_58899_())) {
                        self.spawnRope(level, (ZiplineHookTileEntity)((Object)it), self.getConnectionInfo().get(it.m_58899_()));
                    } else {
                        self.getConnectionPoints().remove(it.m_58899_());
                        self.m_6596_();
                    }
                });
            }
        }
    }
}

