/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ServerLimitation;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.Level;

public class SyncServerInfoMessage {
    private final ByteBuffer limitationData = ByteBuffer.allocate(512);
    private int staminaValue;
    private boolean staminaExhausted;
    private boolean staminaNeedSync;

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.staminaNeedSync);
        packet.writeBoolean(this.staminaExhausted);
        packet.writeInt(this.staminaValue);
        packet.writeBytes(this.limitationData);
        this.limitationData.rewind();
    }

    public static SyncServerInfoMessage decode(FriendlyByteBuf packet) {
        SyncServerInfoMessage message = new SyncServerInfoMessage();
        message.staminaNeedSync = packet.readBoolean();
        message.staminaExhausted = packet.readBoolean();
        message.staminaValue = packet.readInt();
        while (packet.isReadable()) {
            message.limitationData.put(packet.readByte());
        }
        message.limitationData.flip();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            SyncServerInfoMessage.logReceived((Player)player);
            parkourability.getActionInfo().setServerLimitation(ServerLimitation.readFrom(this.limitationData));
            if (this.staminaNeedSync) {
                IStamina stamina = IStamina.get((Player)player);
                if (stamina == null) {
                    return;
                }
                stamina.set(this.staminaValue);
                stamina.setExhaustion(this.staminaExhausted);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public static void logReceived(Player player) {
        ParCool.LOGGER.log(Level.INFO, "Received Server Limitation of [" + player.m_36316_().getName() + "]");
    }

    public static void logSent(Player player) {
        ParCool.LOGGER.log(Level.INFO, "Sent Server Limitation of [" + player.m_36316_().getName() + "]");
    }

    public static void sync(ServerPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        SyncServerInfoMessage msg = new SyncServerInfoMessage();
        parkourability.getActionInfo().getServerLimitation().writeTo(msg.limitationData);
        msg.limitationData.flip();
        msg.staminaNeedSync = false;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static void syncWithStamina(ServerPlayer player, IStamina stamina) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        SyncServerInfoMessage msg = new SyncServerInfoMessage();
        parkourability.getActionInfo().getServerLimitation().writeTo(msg.limitationData);
        msg.limitationData.flip();
        msg.staminaNeedSync = true;
        msg.staminaExhausted = stamina.isExhausted();
        msg.staminaValue = stamina.get();
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
        SyncServerInfoMessage.logSent((Player)player);
    }
}

