/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.epicfight;

import com.alrex.parcool.api.Effects;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.capability.stamina.ParCoolStamina;
import com.alrex.parcool.extern.AdditionalMods;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightStamina
implements IStamina {
    private final Player player;
    private float consumeBuffer = 0.0f;
    private final ParCoolStamina parcoolStamina;

    public EpicFightStamina(Player player) {
        this.player = player;
        this.parcoolStamina = new ParCoolStamina(player);
    }

    @Override
    public int getActualMaxStamina() {
        if (AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            PlayerPatch<?> patch = AdditionalMods.epicFight().getPlayerPatch(this.player);
            if (patch == null) {
                return 0;
            }
            return (int)patch.getMaxStamina();
        }
        return this.parcoolStamina.getActualMaxStamina();
    }

    @Override
    public int get() {
        if (AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            PlayerPatch<?> patch = AdditionalMods.epicFight().getPlayerPatch(this.player);
            if (patch == null) {
                return 0;
            }
            return (int)patch.getStamina();
        }
        return this.parcoolStamina.get();
    }

    @Override
    public int getOldValue() {
        if (AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            return this.get();
        }
        return this.parcoolStamina.getOldValue();
    }

    @Override
    public void consume(int value) {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return;
        }
        if (this.isExhausted() || parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return;
        }
        if (AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.consumeBuffer += (float)value / 60.0f;
        } else {
            this.parcoolStamina.consume(value);
        }
    }

    @Override
    public void recover(int value) {
        if (!AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.parcoolStamina.recover(value);
        }
    }

    @Override
    public boolean isExhausted() {
        Parkourability parkourability = Parkourability.get(this.player);
        if (parkourability == null) {
            return false;
        }
        if (parkourability.getActionInfo().isStaminaInfinite(this.player.m_5833_() || this.player.m_7500_()) || this.player.m_21023_((MobEffect)Effects.INEXHAUSTIBLE.get())) {
            return false;
        }
        if (AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            PlayerPatch<?> patch = AdditionalMods.epicFight().getPlayerPatch(this.player);
            if (patch == null) {
                return false;
            }
            return patch.getStamina() < 0.1f;
        }
        return this.parcoolStamina.isExhausted();
    }

    @Override
    public void setExhaustion(boolean value) {
        if (!AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.parcoolStamina.setExhaustion(value);
        }
    }

    @Override
    public void tick() {
        if (!AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.parcoolStamina.tick();
        }
    }

    @Override
    public void updateOldValue() {
        if (!AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.parcoolStamina.updateOldValue();
        }
    }

    @Override
    public void set(int value) {
        if (!AdditionalMods.epicFight().isEpicFightMode(this.player)) {
            this.parcoolStamina.set(value);
        }
    }

    @Override
    public boolean wantToConsumeOnServer() {
        return AdditionalMods.epicFight().isEpicFightMode(this.player) && this.consumeBuffer != 0.0f;
    }

    @Override
    public int getRequestedValueConsumedOnServer() {
        int neededValue = (int)(this.consumeBuffer * 10000.0f);
        this.consumeBuffer = 0.0f;
        return neededValue;
    }

    @Override
    public boolean isImposingExhaustionPenalty() {
        return !AdditionalMods.epicFight().isEpicFightMode(this.player) && this.parcoolStamina.isImposingExhaustionPenalty();
    }

    public static void consumeOnServer(ServerPlayer player, int value) {
        PlayerPatch<?> patch = AdditionalMods.epicFight().getPlayerPatch((Player)player);
        if (patch == null) {
            return;
        }
        patch.resetActionTick();
        patch.setStamina(patch.getStamina() - (float)value / 10000.0f);
    }
}

