/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class VectorUtil {
    public static double toYawDegree(Vec3 vec) {
        return Math.atan2(vec.f_82481_, vec.f_82479_) * 180.0 / Math.PI - 90.0;
    }

    public static double toYawRadian(Vec3 vec) {
        return Math.atan2(vec.m_7094_(), vec.m_7096_()) - 1.5707963267948966;
    }

    public static double toPitchDegree(Vec3 vec) {
        return -(Math.atan2(vec.m_7098_(), Math.sqrt(vec.m_7096_() * vec.m_7096_() + vec.m_7094_() * vec.m_7094_())) * 180.0 / Math.PI);
    }

    public static Vec3 fromYawDegree(double degree) {
        return new Vec3(-Math.sin(Math.toRadians(degree)), 0.0, Math.cos(Math.toRadians(degree)));
    }

    public static Vec3 rotateYDegrees(Vec3 vector, float baseAngle) {
        float angle = baseAngle * ((float)Math.PI / 180);
        return new Vec3(vector.f_82479_ * (double)Mth.m_14089_((float)angle) - vector.f_82481_ * (double)Mth.m_14031_((float)angle), vector.f_82480_, vector.f_82479_ * (double)Mth.m_14031_((float)angle) + vector.f_82481_ * (double)Mth.m_14089_((float)angle));
    }

    public static float toYaw(Vec3 vector) {
        return (float)Math.toDegrees(Math.atan2(-vector.f_82479_, vector.f_82481_));
    }

    public static boolean isZero(Vec3 vector) {
        return vector.f_82479_ == 0.0 && vector.f_82480_ == 0.0 && vector.f_82481_ == 0.0;
    }

    public static boolean isZero(Vec2 vector) {
        return vector.f_82470_ == 0.0f && vector.f_82471_ == 0.0f;
    }
}

