/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.Variant;
import mcjty.lostcities.worldgen.lost.regassets.PaletteRE;
import mcjty.lostcities.worldgen.lost.regassets.data.BlockEntry;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.PaletteEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

public class Palette
implements ILostCityAsset {
    private final ResourceLocation name;
    private final Map<Character, PE> palette = new HashMap<Character, PE>();
    private final Map<BlockState, BlockState> damaged = new HashMap<BlockState, BlockState>();

    public Palette(PaletteRE object) {
        this.name = object.getRegistryName();
        this.parsePaletteArray(object);
    }

    public Palette(String name) {
        this.name = new ResourceLocation("lostcities", name);
    }

    public void merge(Palette other) {
        this.palette.putAll(other.palette);
        this.damaged.putAll(other.damaged);
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    public Map<BlockState, BlockState> getDamaged() {
        return this.damaged;
    }

    public Map<Character, PE> getPalette() {
        return this.palette;
    }

    public void parsePaletteArray(PaletteRE paletteRE) {
        for (PaletteEntry entry : paletteRE.getPaletteEntries()) {
            Character c = Character.valueOf(entry.getChr().charAt(0));
            BlockState dmg = null;
            if (entry.getDamaged() != null) {
                dmg = Tools.stringToState(entry.getDamaged());
            }
            Info info = new Info(entry.getMob(), entry.getLoot(), entry.getTorch() == null ? false : entry.getTorch(), entry.getTag());
            if (entry.getBlock() != null) {
                String block = entry.getBlock();
                BlockState state = Tools.stringToState(block);
                this.palette.put(c, new PE(state, info));
                if (dmg == null) continue;
                this.damaged.put(state, dmg);
                continue;
            }
            if (entry.getVariant() != null) {
                String variantName = entry.getVariant();
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                ServerLevel level = server.m_129880_(Level.f_46428_);
                Variant variant = AssetRegistries.VARIANTS.getOrThrow((CommonLevelAccessor)level, variantName);
                List<Pair<Integer, BlockState>> blocks = variant.getBlocks();
                if (dmg != null) {
                    for (Pair<Integer, BlockState> pair : blocks) {
                        this.damaged.put((BlockState)pair.getRight(), dmg);
                    }
                }
                this.addMappingViaState(c.charValue(), blocks, info);
                continue;
            }
            if (entry.getFrompalette() != null) {
                String value = entry.getFrompalette();
                this.palette.put(c, new PE(value, info));
                continue;
            }
            if (entry.getBlocks() != null) {
                List<BlockEntry> entryBlocks = entry.getBlocks();
                ArrayList<Pair<Integer, BlockState>> blocks = new ArrayList<Pair<Integer, BlockState>>();
                for (BlockEntry ob : entryBlocks) {
                    Integer f = ob.random();
                    String block = ob.block();
                    BlockState state = Tools.stringToState(block);
                    blocks.add((Pair<Integer, BlockState>)Pair.of((Object)f, (Object)state));
                    if (dmg == null) continue;
                    this.damaged.put(state, dmg);
                }
                this.addMappingViaState(c.charValue(), blocks, info);
                continue;
            }
            throw new RuntimeException("Illegal palette " + String.valueOf(this.name) + "!");
        }
    }

    private Palette addMappingViaState(char c, List<Pair<Integer, BlockState>> randomBlocks, Info info) {
        this.palette.put(Character.valueOf(c), new PE(randomBlocks.toArray(new Pair[randomBlocks.size()]), info));
        return this;
    }

    public record Info(String mobId, String loot, boolean isTorch, CompoundTag tag) {
        public boolean isSpecial() {
            return this.mobId != null || this.loot != null || this.isTorch || this.tag != null;
        }
    }

    public record PE(Object blocks, Info info) {
    }
}

