/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.smileycorp.hordes.common.entities.PlayerZombie;

public class ZombiePlayerModel<T extends Zombie>
extends PlayerModel<T> {
    protected boolean fixedArms = false;
    protected final Color colour;
    protected final boolean isDrowned;

    public ZombiePlayerModel(ModelPart part) {
        this(part, Color.WHITE, false);
    }

    public ZombiePlayerModel(ModelPart part, Color colour, boolean isDrowned) {
        super(part, false);
        this.colour = colour;
        this.isDrowned = isDrowned;
    }

    public void prepareMobModel(T entity, float f1, float f2, float f3) {
        if (!this.fixedArms) {
            Optional<UUID> optional = ((PlayerZombie)entity).getPlayerUUID();
            if (optional.isPresent() && DefaultPlayerSkin.m_118629_((UUID)optional.get()).equals("slim")) {
                this.f_103380_ = true;
            }
            this.fixedArms = true;
        }
        if (this.isDrowned) {
            this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
            this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
            ItemStack itemstack = entity.m_21120_(InteractionHand.MAIN_HAND);
            if (itemstack.m_150930_(Items.f_42713_) && entity.m_5912_()) {
                if (entity.m_5737_() == HumanoidArm.RIGHT) {
                    this.f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                } else {
                    this.f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
                }
            }
        }
        super.m_6839_(entity, f1, f2, f3);
    }

    public void setupAnim(T entity, float p_225597_2_, float p_225597_3_, float p_225597_4_, float p_225597_5_, float p_225597_6_) {
        super.m_6973_(entity, p_225597_2_, p_225597_3_, p_225597_4_, p_225597_5_, p_225597_6_);
        AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)entity.m_5912_(), (float)this.f_102608_, (float)p_225597_4_);
        if (this.isDrowned) {
            if (this.f_102815_ == HumanoidModel.ArmPose.THROW_SPEAR) {
                this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102812_.f_104204_ = 0.0f;
            }
            if (this.f_102816_ == HumanoidModel.ArmPose.THROW_SPEAR) {
                this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - (float)Math.PI;
                this.f_102811_.f_104204_ = 0.0f;
            }
            if (this.f_102818_ > 0.0f) {
                this.f_102811_.f_104203_ = this.m_102835_(this.f_102818_, this.f_102811_.f_104203_, -2.5132742f) + this.f_102818_ * 0.35f * Mth.m_14031_((float)(0.1f * p_225597_4_));
                this.f_102812_.f_104203_ = this.m_102835_(this.f_102818_, this.f_102812_.f_104203_, -2.5132742f) - this.f_102818_ * 0.35f * Mth.m_14031_((float)(0.1f * p_225597_4_));
                this.f_102811_.f_104205_ = this.m_102835_(this.f_102818_, this.f_102811_.f_104205_, -0.15f);
                this.f_102812_.f_104205_ = this.m_102835_(this.f_102818_, this.f_102812_.f_104205_, 0.15f);
                this.f_102814_.f_104203_ -= this.f_102818_ * 0.55f * Mth.m_14031_((float)(0.1f * p_225597_4_));
                this.f_102813_.f_104203_ += this.f_102818_ * 0.55f * Mth.m_14031_((float)(0.1f * p_225597_4_));
                this.f_102808_.f_104203_ = 0.0f;
            }
        }
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.m_7695_(poseStack, consumer, packedLight, packedOverlay, (float)this.colour.getRed() / 255.0f, (float)this.colour.getGreen() / 255.0f, (float)this.colour.getBlue() / 255.0f, 1.0f);
    }
}

