/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.smileycorp.atlas.api.util.WeightedOutputs;
import net.smileycorp.hordes.hordeevent.HordeSpawnEntry;

public class WeightedSpawnTable
extends WeightedOutputs<HordeSpawnEntry> {
    private Map<HordeSpawnEntry, Integer> timesSpawned = Maps.newHashMap();

    public WeightedSpawnTable(List<Map.Entry<HordeSpawnEntry, Integer>> spawnmap) {
        super(1, spawnmap);
    }

    public List<HordeSpawnEntry> getResults(RandomSource rand, int tries) {
        ArrayList<HordeSpawnEntry> list = new ArrayList<HordeSpawnEntry>();
        ArrayList mappedEntries = Lists.newArrayList();
        int max = 0;
        for (Map.Entry entry : this.entries) {
            HordeSpawnEntry spawnEntry = (HordeSpawnEntry)entry.getKey();
            int spawned = 0;
            for (int i = 0; i < spawnEntry.minSpawns; ++i) {
                list.add(spawnEntry);
                --tries;
                ++spawned;
            }
            this.timesSpawned.put(spawnEntry, spawned);
            mappedEntries.add(new AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>(spawnEntry, max));
            max += ((Integer)entry.getValue()).intValue();
        }
        if (max > 0) {
            Collections.reverse(mappedEntries);
            for (int i = 0; i < tries; ++i) {
                HordeSpawnEntry spawnEntry = this.getEntry(rand, mappedEntries, max);
                if (spawnEntry == null) continue;
                list.add(spawnEntry);
            }
        }
        return list;
    }

    public HordeSpawnEntry getEntry(RandomSource rand, List<Map.Entry<HordeSpawnEntry, Integer>> mappedEntries, int max) {
        int result = rand.m_188503_(max);
        for (Map.Entry<HordeSpawnEntry, Integer> entry : mappedEntries) {
            if (result < entry.getValue()) continue;
            HordeSpawnEntry spawnEntry = entry.getKey();
            if (spawnEntry.maxSpawns > 0 && spawnEntry.maxSpawns <= this.timesSpawned.get(spawnEntry)) {
                return this.getEntry(rand, mappedEntries, max);
            }
            this.timesSpawned.put(spawnEntry, this.timesSpawned.get(spawnEntry) + 1);
            return entry.getKey();
        }
        return null;
    }
}

