/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection.network;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.network.AbstractMessage;
import net.smileycorp.hordes.infection.client.ClientInfectionEventHandler;

public class SyncWearableProtectionMessage
extends AbstractMessage {
    private final List<Pair<Item, Integer>> data = Lists.newArrayList();

    public SyncWearableProtectionMessage() {
    }

    public SyncWearableProtectionMessage(Map<Item, Float> wearableProtection) {
        wearableProtection.forEach((item, chance) -> this.data.add((Pair<Item, Integer>)Pair.of((Object)item, (Object)Mth.m_14045_((int)((int)(100.0f * (1.0f - chance.floatValue()))), (int)-100, (int)100))));
    }

    public void read(FriendlyByteBuf buf) {
        while (buf.isReadable()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(buf.m_130277_()));
            if (item == null) continue;
            this.data.add((Pair<Item, Integer>)Pair.of((Object)item, (Object)buf.readByte()));
        }
    }

    public void m_5779_(FriendlyByteBuf buf) {
        this.data.forEach(e -> {
            buf.m_130070_(ForgeRegistries.ITEMS.getKey((Object)((Item)e.getFirst())).toString());
            buf.writeByte(((Integer)e.getSecond()).intValue());
        });
    }

    public void m_5797_(PacketListener handler) {
    }

    public void process(NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientInfectionEventHandler.readWearableProtection(this.data)));
        ctx.setPacketHandled(true);
    }
}

