/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.ai.FleeEntityGoal;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.network.CureEntityMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MixinMob
extends LivingEntity {
    @Shadow
    public GoalSelector f_21345_;

    public MixinMob(Level level) {
        super(null, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"checkAndHandleImportantInteractions"}, cancellable=true)
    public void checkAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callback) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            return;
        }
        if (!HordesInfection.isCure(stack)) {
            return;
        }
        this.m_21195_((MobEffect)HordesInfection.INFECTED.get());
        if (!player.m_9236_().f_46443_) {
            InfectionPacketHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> player.m_9236_().m_46745_(this.m_20097_())), new CureEntityMessage(this));
        }
        if (!player.m_7500_()) {
            ItemStack container = stack.m_41720_().getCraftingRemainingItem(stack);
            if (stack.m_41763_() && player instanceof ServerPlayer) {
                stack.m_220157_(1, player.m_9236_().f_46441_, (ServerPlayer)player);
            } else {
                stack.m_41774_(1);
            }
            if (stack.m_41619_() && !container.m_41619_()) {
                player.m_21008_(hand, container);
            }
        }
        callback.setReturnValue((Object)InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
    }

    @Inject(at={@At(value="HEAD")}, method={"isSunBurnTick"}, cancellable=true)
    public void isSunBurnTick(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof AbstractSkeleton & (Boolean)CommonConfigHandler.skeletonsBurn.get() == false) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shouldDespawnInPeaceful"}, cancellable=true)
    public void shouldDespawnInPeaceful(CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)true);
        }
    }

    @WrapOperation(method={"convertTo"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityType;create(Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/entity/Entity;")})
    private Entity convertTo(EntityType instance, Level level, Operation<Entity> original) {
        Entity entity = (Entity)original.call(new Object[]{instance, level});
        if (!(entity instanceof Mob)) {
            return entity;
        }
        Mob converted = (Mob)entity;
        LazyOptional beforeOptional = this.getCapability(HordesCapabilities.HORDESPAWN);
        LazyOptional afterOptional = converted.getCapability(HordesCapabilities.HORDESPAWN);
        if (!beforeOptional.isPresent() && !afterOptional.isPresent()) {
            return converted;
        }
        if (!((HordeSpawn)beforeOptional.orElseGet(null)).isHordeSpawned()) {
            return converted;
        }
        String uuid = ((HordeSpawn)beforeOptional.orElseGet(null)).getPlayerUUID();
        if (!DataUtils.isValidUUID((String)uuid)) {
            return converted;
        }
        ((HordeSpawn)afterOptional.orElseGet(null)).setPlayerUUID(uuid);
        ((HordeSpawn)beforeOptional.orElseGet(null)).setPlayerUUID("");
        HordeEvent horde = HordeSavedData.getData((ServerLevel)this.m_9236_()).getEvent(UUID.fromString(uuid));
        if (horde != null) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid));
            horde.registerEntity(converted, player);
            horde.removeEntity((Mob)this);
            converted.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
            if (converted instanceof PathfinderMob) {
                converted.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)converted, new Class[0]));
            }
            converted.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(converted, Player.class, true));
        }
        return converted;
    }

    @Inject(at={@At(value="TAIL")}, method={"convertTo"}, cancellable=true)
    public void convertTo(EntityType<?> type, boolean keepEquipment, CallbackInfoReturnable<Mob> callback) {
        Mob converted = (Mob)callback.getReturnValue();
        LazyOptional optional = converted.getCapability(HordesCapabilities.HORDESPAWN);
        if (!optional.isPresent()) {
            return;
        }
        if (!((HordeSpawn)optional.orElseGet(null)).isHordeSpawned()) {
            return;
        }
        String uuid = ((HordeSpawn)optional.orElseGet(null)).getPlayerUUID();
        if (DataUtils.isValidUUID((String)uuid)) {
            ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid));
            if (player == null) {
                return;
            }
            HordeEvent horde = HordeSavedData.getData((ServerLevel)this.m_9236_()).getEvent(player);
            if (horde == null) {
                return;
            }
            if (!horde.isActive(player)) {
                return;
            }
            horde.registerEntity((Mob)this, player);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"registerGoals"}, cancellable=true)
    public void registerGoals(CallbackInfo callback) {
        if (((Boolean)CommonConfigHandler.piglinsHuntZombies.get()).booleanValue() && this instanceof Piglin) {
            this.f_21345_.m_25352_(1, (Goal)new FleeEntityGoal((Mob)this, 1.5, 5.0, HordesInfection::canCauseInfection));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canBeLeashed"})
    public void canBeLeashed(Player player, CallbackInfoReturnable<Boolean> callback) {
        if (this instanceof ZombieHorse && ((Boolean)CommonConfigHandler.aggressiveZombieHorses.get()).booleanValue()) {
            callback.setReturnValue((Object)false);
        }
    }
}

