/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.internal.proxy;

import it.zerono.mods.zerocore.internal.InternalCommand;
import it.zerono.mods.zerocore.internal.client.RenderTypes;
import it.zerono.mods.zerocore.internal.proxy.GuiErrorData;
import it.zerono.mods.zerocore.internal.proxy.IProxy;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.GuiHelper;
import it.zerono.mods.zerocore.lib.client.gui.IRichText;
import it.zerono.mods.zerocore.lib.client.gui.sprite.AtlasSpriteSupplier;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.util.thread.EffectiveSide;
import net.minecraftforge.network.NetworkDirection;
import org.jetbrains.annotations.Nullable;

public class ClientProxy
implements IProxy {
    private static final Colour ERROR_BACKGROUND_COLOUR = Colour.fromARGB(0x5F5E5E5E);
    private static final Colour ERROR_HIGHLIGHT1_COLOUR = Colour.fromARGB(1357442637);
    private static final Colour ERROR_HIGHLIGHT2_COLOUR = Colour.fromARGB(1349809958);
    private static final int ERROR_BORDER = 5;
    private static volatile long s_lastRenderTime = System.currentTimeMillis();
    private final GuiErrorData _guiErrorData = new GuiErrorData();

    public ClientProxy() {
        IEventBus modBus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        modBus.register((Object)this);
        modBus.register((Object)AtlasSpriteSupplier.INSTANCE);
        IEventBus forgeBus = (IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get();
        forgeBus.addListener(this::onRenderTick);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onGameOverlayRender);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onGuiDrawScreenEventPost);
        forgeBus.addListener(EventPriority.NORMAL, true, this::onHighlightBlock);
        forgeBus.addListener(this::onLoggedOut);
    }

    public void onLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        this.clearErrorReport();
    }

    @SubscribeEvent
    public void onClientInit(FMLClientSetupEvent event) {
        CodeHelper.addResourceReloadListener((PreparableReloadListener)AtlasSpriteSupplier.INSTANCE);
    }

    @Override
    public Optional<Level> getClientWorld() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91073_);
    }

    @Override
    public Optional<Player> getClientPlayer() {
        return Optional.ofNullable(Minecraft.m_91087_().f_91074_);
    }

    @Override
    public void markBlockRangeForRenderUpdate(BlockPos min, BlockPos max) {
        Minecraft.m_91087_().f_91060_.m_109494_(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    @Override
    public void sendPlayerStatusMessage(Player player, Component message) {
        Minecraft.m_91087_().f_91065_.m_93063_(message, false);
    }

    @Override
    public void addResourceReloadListener(PreparableReloadListener listener) {
        Minecraft mc = Minecraft.m_91087_();
        if (null != mc && mc.m_91098_() instanceof ReloadableResourceManager) {
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(listener);
        }
    }

    @Override
    public long getLastRenderTime() {
        return s_lastRenderTime;
    }

    @Override
    public void displayErrorToPlayer(@Nullable BlockPos position, Component ... messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void displayErrorToPlayer(@Nullable BlockPos position, List<Component> messages) {
        this._guiErrorData.addErrors(position, messages);
    }

    @Override
    public void clearErrorReport() {
        this._guiErrorData.resetErrors();
    }

    @Override
    public RecipeManager getRecipeManager() {
        if (EffectiveSide.get().isClient()) {
            ClientPacketListener handler = Minecraft.m_91087_().m_91403_();
            return null != handler ? handler.m_105141_() : null;
        }
        return CodeHelper.getMinecraftServer().map(MinecraftServer::m_129894_).orElse(null);
    }

    @Override
    public void handleInternalCommand(InternalCommand command, CompoundTag data, NetworkDirection direction) {
        switch (command) {
            case ClearRecipes: {
                ModRecipeType.invalidate();
                break;
            }
            case DebugGuiFrame: {
                GuiHelper.enableGuiDebugFrame(data.m_128441_("enable") && data.m_128471_("enable"));
                break;
            }
            case ContainerDataSync: {
                this.getClientPlayer().map(p -> p.f_36096_).filter(c -> c instanceof ModContainer).map(c -> (ModContainer)c).ifPresent(mc -> mc.onContainerDataSync(data));
                break;
            }
            default: {
                IProxy.super.handleInternalCommand(command, data, direction);
            }
        }
    }

    @Override
    public void debugUngrabMouse() {
        Minecraft.m_91087_().f_91067_.m_91602_();
    }

    private void onRenderTick(TickEvent.RenderTickEvent event) {
        if (TickEvent.Phase.END == event.phase) {
            s_lastRenderTime = System.currentTimeMillis();
            this._guiErrorData.tick();
        }
    }

    private void onGameOverlayRender(RenderGuiOverlayEvent.Post event) {
        if (!ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getGuiGraphics());
        }
    }

    private void onGuiDrawScreenEventPost(ScreenEvent.Render.Post event) {
        if (ClientProxy.isGuiOpen()) {
            this.paintErrorMessage(event.getGuiGraphics());
        }
    }

    private void onHighlightBlock(RenderHighlightEvent.Block event) {
        BlockHitResult result = event.getTarget();
        BlockPos position = result.m_82425_();
        if (HitResult.Type.BLOCK == result.m_6662_() && this._guiErrorData.test(position)) {
            Vec3 projectedView = event.getCamera().m_90583_();
            ModRenderHelper.paintVoxelShape(Shapes.m_83144_(), event.getPoseStack(), event.getMultiBufferSource(), RenderTypes.ERROR_BLOCK_HIGHLIGHT, (double)position.m_123341_() - projectedView.m_7096_(), (double)position.m_123342_() - projectedView.m_7098_(), (double)position.m_123343_() - projectedView.m_7094_(), ERROR_HIGHLIGHT1_COLOUR);
            event.setCanceled(true);
        }
    }

    private void paintErrorMessage(GuiGraphics gfx) {
        IRichText texts = this._guiErrorData.apply(Minecraft.m_91087_().m_91268_().m_85445_() / 2);
        if (texts.isEmpty()) {
            return;
        }
        ModRenderHelper.paintMessage(gfx, texts, 5, 5, 300, 5, ERROR_BACKGROUND_COLOUR, ERROR_HIGHLIGHT1_COLOUR, ERROR_HIGHLIGHT2_COLOUR);
    }

    private static boolean isGuiOpen() {
        return null != Minecraft.m_91087_().f_91080_;
    }
}

