/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.holder;

import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import java.util.Objects;
import net.minecraft.util.Mth;

public abstract class AbstractHeldRecipe<Recipe extends ModRecipe>
implements IHeldRecipe<Recipe> {
    private final Recipe _recipe;
    private final IRecipeHolder<Recipe> _holder;
    private int _currentTick;

    protected <Holder extends IRecipeHolder<Recipe>> AbstractHeldRecipe(Recipe recipe, Holder holder) {
        this._recipe = (ModRecipe)Objects.requireNonNull(recipe);
        this._holder = Objects.requireNonNull(holder);
        this._currentTick = 0;
    }

    @Override
    public boolean processRecipe() {
        Recipe recipe = this.getRecipe();
        Object holder = this.getRecipeHolder();
        int requiredTicks = holder.getRequiredTicks(recipe);
        if (!holder.canProcessRecipe(recipe) || requiredTicks < 1) {
            this._currentTick = 0;
            holder.onActiveStatusChanged(false);
            return false;
        }
        if (0 == this._currentTick) {
            holder.onActiveStatusChanged(true);
            this.onBeginRecipeProcessing();
            holder.onBeginRecipeProcessing();
        }
        ++this._currentTick;
        this.onRecipeTickProcessed(this._currentTick);
        holder.onRecipeTickProcessed(this._currentTick);
        if (requiredTicks <= this._currentTick) {
            this._currentTick = 0;
            this.onRecipeProcessed();
            holder.onRecipeProcessed();
            holder.onActiveStatusChanged(false);
        }
        return true;
    }

    @Override
    public Recipe getRecipe() {
        return this._recipe;
    }

    @Override
    public <Holder extends IRecipeHolder<Recipe>> Holder getRecipeHolder() {
        return (Holder)this._holder;
    }

    @Override
    public int getCurrentTick() {
        return this._currentTick;
    }

    @Override
    public void loadCurrentTick(int tick) {
        this._currentTick = Mth.m_14045_((int)tick, (int)0, (int)this.getRecipeHolder().getRequiredTicks(this.getRecipe()));
    }

    @Override
    public double getProgress() {
        return (double)this.getCurrentTick() / (double)this.getRecipeHolder().getRequiredTicks(this.getRecipe());
    }
}

